// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates settings for the end of meeting reminder feature that are applied to a room profile. The end of meeting reminder enables Alexa to remind users when a meeting is ending.
 */
public class CreateEndOfMeetingReminder private constructor(builder: Builder) {
    /**
     * Whether an end of meeting reminder is enabled or not.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * A range of 3 to 15 minutes that determines when the reminder begins.
     */
    public val reminderAtMinutes: List<Int> = requireNotNull(builder.reminderAtMinutes) { "A non-null value must be provided for reminderAtMinutes" }
    /**
     * The type of sound that users hear during the end of meeting reminder.
     */
    public val reminderType: aws.sdk.kotlin.services.alexaforbusiness.model.EndOfMeetingReminderType = requireNotNull(builder.reminderType) { "A non-null value must be provided for reminderType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.alexaforbusiness.model.CreateEndOfMeetingReminder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndOfMeetingReminder(")
        append("enabled=$enabled,")
        append("reminderAtMinutes=$reminderAtMinutes,")
        append("reminderType=$reminderType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled.hashCode()
        result = 31 * result + (reminderAtMinutes.hashCode())
        result = 31 * result + (reminderType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEndOfMeetingReminder

        if (enabled != other.enabled) return false
        if (reminderAtMinutes != other.reminderAtMinutes) return false
        if (reminderType != other.reminderType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.alexaforbusiness.model.CreateEndOfMeetingReminder = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether an end of meeting reminder is enabled or not.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A range of 3 to 15 minutes that determines when the reminder begins.
         */
        public var reminderAtMinutes: List<Int>? = null
        /**
         * The type of sound that users hear during the end of meeting reminder.
         */
        public var reminderType: aws.sdk.kotlin.services.alexaforbusiness.model.EndOfMeetingReminderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.alexaforbusiness.model.CreateEndOfMeetingReminder) : this() {
            this.enabled = x.enabled
            this.reminderAtMinutes = x.reminderAtMinutes
            this.reminderType = x.reminderType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.alexaforbusiness.model.CreateEndOfMeetingReminder = CreateEndOfMeetingReminder(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            if (reminderAtMinutes == null) reminderAtMinutes = emptyList()
            if (reminderType == null) reminderType = EndOfMeetingReminderType.SdkUnknown("no value provided")
            return this
        }
    }
}
