// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The audio message. There is a 1 MB limit on the audio file input and the only supported format is MP3. To convert your MP3 audio files to an Alexa-friendly,
 *
 * required codec version (MPEG version 2) and bit rate (48 kbps), you might use converter software. One option for this is a command-line tool, FFmpeg. For more information, see [FFmpeg](https://www.ffmpeg.org/). The following command converts the provided <input-file> to an MP3 file that is played in the announcement:
 *
 * `ffmpeg -i <input-file> -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000 <output-file.mp3>`
 */
public class Audio private constructor(builder: Builder) {
    /**
     * The locale of the audio message. Currently, en-US is supported.
     */
    public val locale: aws.sdk.kotlin.services.alexaforbusiness.model.Locale = requireNotNull(builder.locale) { "A non-null value must be provided for locale" }
    /**
     * The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe characters are valid. For more information, see [Safe Characters](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters).
     */
    public val location: kotlin.String = requireNotNull(builder.location) { "A non-null value must be provided for location" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.alexaforbusiness.model.Audio = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Audio(")
        append("locale=$locale,")
        append("location=$location")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = locale.hashCode()
        result = 31 * result + (location.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Audio

        if (locale != other.locale) return false
        if (location != other.location) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.alexaforbusiness.model.Audio = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The locale of the audio message. Currently, en-US is supported.
         */
        public var locale: aws.sdk.kotlin.services.alexaforbusiness.model.Locale? = null
        /**
         * The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe characters are valid. For more information, see [Safe Characters](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters).
         */
        public var location: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.alexaforbusiness.model.Audio) : this() {
            this.locale = x.locale
            this.location = x.location
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.alexaforbusiness.model.Audio = Audio(this)

        internal fun correctErrors(): Builder {
            if (locale == null) locale = Locale.SdkUnknown("no value provided")
            if (location == null) location = ""
            return this
        }
    }
}
