// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The data associated with a network profile.
 */
public class NetworkProfileData private constructor(builder: Builder) {
    /**
     * The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * Detailed information about a device's network profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
     */
    public val eapMethod: aws.sdk.kotlin.services.alexaforbusiness.model.NetworkEapMethod? = builder.eapMethod
    /**
     * The ARN of the network profile associated with a device.
     */
    public val networkProfileArn: kotlin.String? = builder.networkProfileArn
    /**
     * The name of the network profile associated with a device.
     */
    public val networkProfileName: kotlin.String? = builder.networkProfileName
    /**
     * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
     */
    public val securityType: aws.sdk.kotlin.services.alexaforbusiness.model.NetworkSecurityType? = builder.securityType
    /**
     * The SSID of the Wi-Fi network.
     */
    public val ssid: kotlin.String? = builder.ssid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.alexaforbusiness.model.NetworkProfileData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkProfileData(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("description=$description,")
        append("eapMethod=$eapMethod,")
        append("networkProfileArn=$networkProfileArn,")
        append("networkProfileName=$networkProfileName,")
        append("securityType=$securityType,")
        append("ssid=$ssid")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eapMethod?.hashCode() ?: 0)
        result = 31 * result + (networkProfileArn?.hashCode() ?: 0)
        result = 31 * result + (networkProfileName?.hashCode() ?: 0)
        result = 31 * result + (securityType?.hashCode() ?: 0)
        result = 31 * result + (ssid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkProfileData

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (description != other.description) return false
        if (eapMethod != other.eapMethod) return false
        if (networkProfileArn != other.networkProfileArn) return false
        if (networkProfileName != other.networkProfileName) return false
        if (securityType != other.securityType) return false
        if (ssid != other.ssid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.alexaforbusiness.model.NetworkProfileData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the Private Certificate Authority (PCA) created in AWS Certificate Manager (ACM). This is used to issue certificates to the devices.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * Detailed information about a device's network profile.
         */
        public var description: kotlin.String? = null
        /**
         * The authentication standard that is used in the EAP framework. Currently, EAP_TLS is supported.
         */
        public var eapMethod: aws.sdk.kotlin.services.alexaforbusiness.model.NetworkEapMethod? = null
        /**
         * The ARN of the network profile associated with a device.
         */
        public var networkProfileArn: kotlin.String? = null
        /**
         * The name of the network profile associated with a device.
         */
        public var networkProfileName: kotlin.String? = null
        /**
         * The security type of the Wi-Fi network. This can be WPA2_ENTERPRISE, WPA2_PSK, WPA_PSK, WEP, or OPEN.
         */
        public var securityType: aws.sdk.kotlin.services.alexaforbusiness.model.NetworkSecurityType? = null
        /**
         * The SSID of the Wi-Fi network.
         */
        public var ssid: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.alexaforbusiness.model.NetworkProfileData) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.description = x.description
            this.eapMethod = x.eapMethod
            this.networkProfileArn = x.networkProfileArn
            this.networkProfileName = x.networkProfileName
            this.securityType = x.securityType
            this.ssid = x.ssid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.alexaforbusiness.model.NetworkProfileData = NetworkProfileData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
