// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.alexaforbusiness.auth.AlexaForBusinessAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.alexaforbusiness.auth.AlexaForBusinessIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.alexaforbusiness.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.alexaforbusiness.model.*
import aws.sdk.kotlin.services.alexaforbusiness.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultAlexaForBusinessClient(override val config: AlexaForBusinessClient.Config) : AlexaForBusinessClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = AlexaForBusinessIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "a4b")
        }
        toMap()
    }
    private val authSchemeAdapter = AlexaForBusinessAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.alexaforbusiness"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user implicitly accepts access to this skill during enablement.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun approveSkill(input: ApproveSkillRequest): ApproveSkillResponse {
        val op = SdkHttpOperation.build<ApproveSkillRequest, ApproveSkillResponse> {
            serializeWith = ApproveSkillOperationSerializer()
            deserializeWith = ApproveSkillOperationDeserializer()
            operationName = "ApproveSkill"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a contact with a given address book.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateContactWithAddressBook(input: AssociateContactWithAddressBookRequest): AssociateContactWithAddressBookResponse {
        val op = SdkHttpOperation.build<AssociateContactWithAddressBookRequest, AssociateContactWithAddressBookResponse> {
            serializeWith = AssociateContactWithAddressBookOperationSerializer()
            deserializeWith = AssociateContactWithAddressBookOperationDeserializer()
            operationName = "AssociateContactWithAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with the specified network profile.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateDeviceWithNetworkProfile(input: AssociateDeviceWithNetworkProfileRequest): AssociateDeviceWithNetworkProfileResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithNetworkProfileRequest, AssociateDeviceWithNetworkProfileResponse> {
            serializeWith = AssociateDeviceWithNetworkProfileOperationSerializer()
            deserializeWith = AssociateDeviceWithNetworkProfileOperationDeserializer()
            operationName = "AssociateDeviceWithNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all the skills in any skill groups added to that room. This operation requires the device to be online, or else a manual sync is required.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateDeviceWithRoom(input: AssociateDeviceWithRoomRequest): AssociateDeviceWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse> {
            serializeWith = AssociateDeviceWithRoomOperationSerializer()
            deserializeWith = AssociateDeviceWithRoomOperationDeserializer()
            operationName = "AssociateDeviceWithRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices in the room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateSkillGroupWithRoom(input: AssociateSkillGroupWithRoomRequest): AssociateSkillGroupWithRoomResponse {
        val op = SdkHttpOperation.build<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse> {
            serializeWith = AssociateSkillGroupWithRoomOperationSerializer()
            deserializeWith = AssociateSkillGroupWithRoomOperationDeserializer()
            operationName = "AssociateSkillGroupWithRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a skill with a skill group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateSkillWithSkillGroup(input: AssociateSkillWithSkillGroupRequest): AssociateSkillWithSkillGroupResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithSkillGroupRequest, AssociateSkillWithSkillGroupResponse> {
            serializeWith = AssociateSkillWithSkillGroupOperationSerializer()
            deserializeWith = AssociateSkillWithSkillGroupOperationDeserializer()
            operationName = "AssociateSkillWithSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill available for enrolled users to enable on their devices.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun associateSkillWithUsers(input: AssociateSkillWithUsersRequest): AssociateSkillWithUsersResponse {
        val op = SdkHttpOperation.build<AssociateSkillWithUsersRequest, AssociateSkillWithUsersResponse> {
            serializeWith = AssociateSkillWithUsersOperationSerializer()
            deserializeWith = AssociateSkillWithUsersOperationDeserializer()
            operationName = "AssociateSkillWithUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an address book with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createAddressBook(input: CreateAddressBookRequest): CreateAddressBookResponse {
        val op = SdkHttpOperation.build<CreateAddressBookRequest, CreateAddressBookResponse> {
            serializeWith = CreateAddressBookOperationSerializer()
            deserializeWith = CreateAddressBookOperationDeserializer()
            operationName = "CreateAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or weekly interval.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createBusinessReportSchedule(input: CreateBusinessReportScheduleRequest): CreateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<CreateBusinessReportScheduleRequest, CreateBusinessReportScheduleResponse> {
            serializeWith = CreateBusinessReportScheduleOperationSerializer()
            deserializeWith = CreateBusinessReportScheduleOperationDeserializer()
            operationName = "CreateBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds a new conference provider under the user's AWS account.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createConferenceProvider(input: CreateConferenceProviderRequest): CreateConferenceProviderResponse {
        val op = SdkHttpOperation.build<CreateConferenceProviderRequest, CreateConferenceProviderResponse> {
            serializeWith = CreateConferenceProviderOperationSerializer()
            deserializeWith = CreateConferenceProviderOperationDeserializer()
            operationName = "CreateConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a contact with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createContact(input: CreateContactRequest): CreateContactResponse {
        val op = SdkHttpOperation.build<CreateContactRequest, CreateContactResponse> {
            serializeWith = CreateContactOperationSerializer()
            deserializeWith = CreateContactOperationDeserializer()
            operationName = "CreateContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a gateway group with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createGatewayGroup(input: CreateGatewayGroupRequest): CreateGatewayGroupResponse {
        val op = SdkHttpOperation.build<CreateGatewayGroupRequest, CreateGatewayGroupResponse> {
            serializeWith = CreateGatewayGroupOperationSerializer()
            deserializeWith = CreateGatewayGroupOperationDeserializer()
            operationName = "CreateGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a network profile with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createNetworkProfile(input: CreateNetworkProfileRequest): CreateNetworkProfileResponse {
        val op = SdkHttpOperation.build<CreateNetworkProfileRequest, CreateNetworkProfileResponse> {
            serializeWith = CreateNetworkProfileOperationSerializer()
            deserializeWith = CreateNetworkProfileOperationDeserializer()
            operationName = "CreateNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new room profile with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse {
        val op = SdkHttpOperation.build<CreateProfileRequest, CreateProfileResponse> {
            serializeWith = CreateProfileOperationSerializer()
            deserializeWith = CreateProfileOperationDeserializer()
            operationName = "CreateProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a room with the specified details.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createRoom(input: CreateRoomRequest): CreateRoomResponse {
        val op = SdkHttpOperation.build<CreateRoomRequest, CreateRoomResponse> {
            serializeWith = CreateRoomOperationSerializer()
            deserializeWith = CreateRoomOperationDeserializer()
            operationName = "CreateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a skill group with a specified name and description.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createSkillGroup(input: CreateSkillGroupRequest): CreateSkillGroupResponse {
        val op = SdkHttpOperation.build<CreateSkillGroupRequest, CreateSkillGroupResponse> {
            serializeWith = CreateSkillGroupOperationSerializer()
            deserializeWith = CreateSkillGroupOperationDeserializer()
            operationName = "CreateSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a user.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun createUser(input: CreateUserRequest): CreateUserResponse {
        val op = SdkHttpOperation.build<CreateUserRequest, CreateUserResponse> {
            serializeWith = CreateUserOperationSerializer()
            deserializeWith = CreateUserOperationDeserializer()
            operationName = "CreateUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an address book by the address book ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteAddressBook(input: DeleteAddressBookRequest): DeleteAddressBookResponse {
        val op = SdkHttpOperation.build<DeleteAddressBookRequest, DeleteAddressBookResponse> {
            serializeWith = DeleteAddressBookOperationSerializer()
            deserializeWith = DeleteAddressBookOperationDeserializer()
            operationName = "DeleteAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteBusinessReportSchedule(input: DeleteBusinessReportScheduleRequest): DeleteBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<DeleteBusinessReportScheduleRequest, DeleteBusinessReportScheduleResponse> {
            serializeWith = DeleteBusinessReportScheduleOperationSerializer()
            deserializeWith = DeleteBusinessReportScheduleOperationDeserializer()
            operationName = "DeleteBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a conference provider.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteConferenceProvider(input: DeleteConferenceProviderRequest): DeleteConferenceProviderResponse {
        val op = SdkHttpOperation.build<DeleteConferenceProviderRequest, DeleteConferenceProviderResponse> {
            serializeWith = DeleteConferenceProviderOperationSerializer()
            deserializeWith = DeleteConferenceProviderOperationDeserializer()
            operationName = "DeleteConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a contact by the contact ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse {
        val op = SdkHttpOperation.build<DeleteContactRequest, DeleteContactResponse> {
            serializeWith = DeleteContactOperationSerializer()
            deserializeWith = DeleteContactOperationDeserializer()
            operationName = "DeleteContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes a device from Alexa For Business.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse {
        val op = SdkHttpOperation.build<DeleteDeviceRequest, DeleteDeviceResponse> {
            serializeWith = DeleteDeviceOperationSerializer()
            deserializeWith = DeleteDeviceOperationDeserializer()
            operationName = "DeleteDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * When this action is called for a specified shared device, it allows authorized users to delete the device's entire previous history of voice input data and associated response data. This action can be called once every 24 hours for a specific shared device.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteDeviceUsageData(input: DeleteDeviceUsageDataRequest): DeleteDeviceUsageDataResponse {
        val op = SdkHttpOperation.build<DeleteDeviceUsageDataRequest, DeleteDeviceUsageDataResponse> {
            serializeWith = DeleteDeviceUsageDataOperationSerializer()
            deserializeWith = DeleteDeviceUsageDataOperationDeserializer()
            operationName = "DeleteDeviceUsageData"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a gateway group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteGatewayGroup(input: DeleteGatewayGroupRequest): DeleteGatewayGroupResponse {
        val op = SdkHttpOperation.build<DeleteGatewayGroupRequest, DeleteGatewayGroupResponse> {
            serializeWith = DeleteGatewayGroupOperationSerializer()
            deserializeWith = DeleteGatewayGroupOperationDeserializer()
            operationName = "DeleteGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a network profile by the network profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteNetworkProfile(input: DeleteNetworkProfileRequest): DeleteNetworkProfileResponse {
        val op = SdkHttpOperation.build<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse> {
            serializeWith = DeleteNetworkProfileOperationSerializer()
            deserializeWith = DeleteNetworkProfileOperationDeserializer()
            operationName = "DeleteNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room profile by the profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse {
        val op = SdkHttpOperation.build<DeleteProfileRequest, DeleteProfileResponse> {
            serializeWith = DeleteProfileOperationSerializer()
            deserializeWith = DeleteProfileOperationDeserializer()
            operationName = "DeleteProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a room by the room ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteRoom(input: DeleteRoomRequest): DeleteRoomResponse {
        val op = SdkHttpOperation.build<DeleteRoomRequest, DeleteRoomResponse> {
            serializeWith = DeleteRoomOperationSerializer()
            deserializeWith = DeleteRoomOperationDeserializer()
            operationName = "DeleteRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteRoomSkillParameter(input: DeleteRoomSkillParameterRequest): DeleteRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse> {
            serializeWith = DeleteRoomSkillParameterOperationSerializer()
            deserializeWith = DeleteRoomSkillParameterOperationDeserializer()
            operationName = "DeleteRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Unlinks a third-party account from a skill.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteSkillAuthorization(input: DeleteSkillAuthorizationRequest): DeleteSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<DeleteSkillAuthorizationRequest, DeleteSkillAuthorizationResponse> {
            serializeWith = DeleteSkillAuthorizationOperationSerializer()
            deserializeWith = DeleteSkillAuthorizationOperationDeserializer()
            operationName = "DeleteSkillAuthorization"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a skill group by skill group ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteSkillGroup(input: DeleteSkillGroupRequest): DeleteSkillGroupResponse {
        val op = SdkHttpOperation.build<DeleteSkillGroupRequest, DeleteSkillGroupResponse> {
            serializeWith = DeleteSkillGroupOperationSerializer()
            deserializeWith = DeleteSkillGroupOperationDeserializer()
            operationName = "DeleteSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified user by user ARN and enrollment ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializeWith = DeleteUserOperationSerializer()
            deserializeWith = DeleteUserOperationDeserializer()
            operationName = "DeleteUser"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a contact from a given address book.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun disassociateContactFromAddressBook(input: DisassociateContactFromAddressBookRequest): DisassociateContactFromAddressBookResponse {
        val op = SdkHttpOperation.build<DisassociateContactFromAddressBookRequest, DisassociateContactFromAddressBookResponse> {
            serializeWith = DisassociateContactFromAddressBookOperationSerializer()
            deserializeWith = DisassociateContactFromAddressBookOperationDeserializer()
            operationName = "DisassociateContactFromAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is still registered to the account. The device settings and skills are removed from the room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun disassociateDeviceFromRoom(input: DisassociateDeviceFromRoomRequest): DisassociateDeviceFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse> {
            serializeWith = DisassociateDeviceFromRoomOperationSerializer()
            deserializeWith = DisassociateDeviceFromRoomOperationDeserializer()
            operationName = "DisassociateDeviceFromRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from a skill group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun disassociateSkillFromSkillGroup(input: DisassociateSkillFromSkillGroupRequest): DisassociateSkillFromSkillGroupResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromSkillGroupRequest, DisassociateSkillFromSkillGroupResponse> {
            serializeWith = DisassociateSkillFromSkillGroupOperationSerializer()
            deserializeWith = DisassociateSkillFromSkillGroupOperationDeserializer()
            operationName = "DisassociateSkillFromSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun disassociateSkillFromUsers(input: DisassociateSkillFromUsersRequest): DisassociateSkillFromUsersResponse {
        val op = SdkHttpOperation.build<DisassociateSkillFromUsersRequest, DisassociateSkillFromUsersResponse> {
            serializeWith = DisassociateSkillFromUsersOperationSerializer()
            deserializeWith = DisassociateSkillFromUsersOperationDeserializer()
            operationName = "DisassociateSkillFromUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in the room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun disassociateSkillGroupFromRoom(input: DisassociateSkillGroupFromRoomRequest): DisassociateSkillGroupFromRoomResponse {
        val op = SdkHttpOperation.build<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse> {
            serializeWith = DisassociateSkillGroupFromRoomOperationSerializer()
            deserializeWith = DisassociateSkillGroupFromRoomOperationDeserializer()
            operationName = "DisassociateSkillGroupFromRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Forgets smart home appliances associated to a room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun forgetSmartHomeAppliances(input: ForgetSmartHomeAppliancesRequest): ForgetSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ForgetSmartHomeAppliancesRequest, ForgetSmartHomeAppliancesResponse> {
            serializeWith = ForgetSmartHomeAppliancesOperationSerializer()
            deserializeWith = ForgetSmartHomeAppliancesOperationDeserializer()
            operationName = "ForgetSmartHomeAppliances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets address the book details by the address book ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getAddressBook(input: GetAddressBookRequest): GetAddressBookResponse {
        val op = SdkHttpOperation.build<GetAddressBookRequest, GetAddressBookResponse> {
            serializeWith = GetAddressBookOperationSerializer()
            deserializeWith = GetAddressBookOperationDeserializer()
            operationName = "GetAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the existing conference preferences.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getConferencePreference(input: GetConferencePreferenceRequest): GetConferencePreferenceResponse {
        val op = SdkHttpOperation.build<GetConferencePreferenceRequest, GetConferencePreferenceResponse> {
            serializeWith = GetConferencePreferenceOperationSerializer()
            deserializeWith = GetConferencePreferenceOperationDeserializer()
            operationName = "GetConferencePreference"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details about a specific conference provider.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getConferenceProvider(input: GetConferenceProviderRequest): GetConferenceProviderResponse {
        val op = SdkHttpOperation.build<GetConferenceProviderRequest, GetConferenceProviderResponse> {
            serializeWith = GetConferenceProviderOperationSerializer()
            deserializeWith = GetConferenceProviderOperationDeserializer()
            operationName = "GetConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the contact details by the contact ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getContact(input: GetContactRequest): GetContactResponse {
        val op = SdkHttpOperation.build<GetContactRequest, GetContactResponse> {
            serializeWith = GetContactOperationSerializer()
            deserializeWith = GetContactOperationDeserializer()
            operationName = "GetContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a device by device ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse {
        val op = SdkHttpOperation.build<GetDeviceRequest, GetDeviceResponse> {
            serializeWith = GetDeviceOperationSerializer()
            deserializeWith = GetDeviceOperationDeserializer()
            operationName = "GetDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getGateway(input: GetGatewayRequest): GetGatewayResponse {
        val op = SdkHttpOperation.build<GetGatewayRequest, GetGatewayResponse> {
            serializeWith = GetGatewayOperationSerializer()
            deserializeWith = GetGatewayOperationDeserializer()
            operationName = "GetGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the details of a gateway group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getGatewayGroup(input: GetGatewayGroupRequest): GetGatewayGroupResponse {
        val op = SdkHttpOperation.build<GetGatewayGroupRequest, GetGatewayGroupResponse> {
            serializeWith = GetGatewayGroupOperationSerializer()
            deserializeWith = GetGatewayGroupOperationDeserializer()
            operationName = "GetGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the configured values for the user enrollment invitation email template.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getInvitationConfiguration(input: GetInvitationConfigurationRequest): GetInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<GetInvitationConfigurationRequest, GetInvitationConfigurationResponse> {
            serializeWith = GetInvitationConfigurationOperationSerializer()
            deserializeWith = GetInvitationConfigurationOperationDeserializer()
            operationName = "GetInvitationConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network profile details by the network profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getNetworkProfile(input: GetNetworkProfileRequest): GetNetworkProfileResponse {
        val op = SdkHttpOperation.build<GetNetworkProfileRequest, GetNetworkProfileResponse> {
            serializeWith = GetNetworkProfileOperationSerializer()
            deserializeWith = GetNetworkProfileOperationDeserializer()
            operationName = "GetNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a room profile by profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getProfile(input: GetProfileRequest): GetProfileResponse {
        val op = SdkHttpOperation.build<GetProfileRequest, GetProfileResponse> {
            serializeWith = GetProfileOperationSerializer()
            deserializeWith = GetProfileOperationDeserializer()
            operationName = "GetProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets room details by room ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getRoom(input: GetRoomRequest): GetRoomResponse {
        val op = SdkHttpOperation.build<GetRoomRequest, GetRoomResponse> {
            serializeWith = GetRoomOperationSerializer()
            deserializeWith = GetRoomOperationDeserializer()
            operationName = "GetRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getRoomSkillParameter(input: GetRoomSkillParameterRequest): GetRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse> {
            serializeWith = GetRoomSkillParameterOperationSerializer()
            deserializeWith = GetRoomSkillParameterOperationDeserializer()
            operationName = "GetRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets skill group details by skill group ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun getSkillGroup(input: GetSkillGroupRequest): GetSkillGroupResponse {
        val op = SdkHttpOperation.build<GetSkillGroupRequest, GetSkillGroupResponse> {
            serializeWith = GetSkillGroupOperationSerializer()
            deserializeWith = GetSkillGroupOperationDeserializer()
            operationName = "GetSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the details of the schedules that a user configured. A download URL of the report associated with each schedule is returned every time this action is called. A new download URL is returned each time, and is valid for 24 hours.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listBusinessReportSchedules(input: ListBusinessReportSchedulesRequest): ListBusinessReportSchedulesResponse {
        val op = SdkHttpOperation.build<ListBusinessReportSchedulesRequest, ListBusinessReportSchedulesResponse> {
            serializeWith = ListBusinessReportSchedulesOperationSerializer()
            deserializeWith = ListBusinessReportSchedulesOperationDeserializer()
            operationName = "ListBusinessReportSchedules"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists conference providers under a specific AWS account.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listConferenceProviders(input: ListConferenceProvidersRequest): ListConferenceProvidersResponse {
        val op = SdkHttpOperation.build<ListConferenceProvidersRequest, ListConferenceProvidersResponse> {
            serializeWith = ListConferenceProvidersOperationSerializer()
            deserializeWith = ListConferenceProvidersOperationDeserializer()
            operationName = "ListConferenceProviders"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the device event history, including device connection status, for up to 30 days.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listDeviceEvents(input: ListDeviceEventsRequest): ListDeviceEventsResponse {
        val op = SdkHttpOperation.build<ListDeviceEventsRequest, ListDeviceEventsResponse> {
            serializeWith = ListDeviceEventsOperationSerializer()
            deserializeWith = ListDeviceEventsOperationDeserializer()
            operationName = "ListDeviceEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listGatewayGroups(input: ListGatewayGroupsRequest): ListGatewayGroupsResponse {
        val op = SdkHttpOperation.build<ListGatewayGroupsRequest, ListGatewayGroupsResponse> {
            serializeWith = ListGatewayGroupsOperationSerializer()
            deserializeWith = ListGatewayGroupsOperationDeserializer()
            operationName = "ListGatewayGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that gateway group ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listGateways(input: ListGatewaysRequest): ListGatewaysResponse {
        val op = SdkHttpOperation.build<ListGatewaysRequest, ListGatewaysResponse> {
            serializeWith = ListGatewaysOperationSerializer()
            deserializeWith = ListGatewaysOperationDeserializer()
            operationName = "ListGateways"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all enabled skills in a specific skill group.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listSkills(input: ListSkillsRequest): ListSkillsResponse {
        val op = SdkHttpOperation.build<ListSkillsRequest, ListSkillsResponse> {
            serializeWith = ListSkillsOperationSerializer()
            deserializeWith = ListSkillsOperationDeserializer()
            operationName = "ListSkills"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all categories in the Alexa skill store.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listSkillsStoreCategories(input: ListSkillsStoreCategoriesRequest): ListSkillsStoreCategoriesResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreCategoriesRequest, ListSkillsStoreCategoriesResponse> {
            serializeWith = ListSkillsStoreCategoriesOperationSerializer()
            deserializeWith = ListSkillsStoreCategoriesOperationDeserializer()
            operationName = "ListSkillsStoreCategories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all skills in the Alexa skill store by category.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listSkillsStoreSkillsByCategory(input: ListSkillsStoreSkillsByCategoryRequest): ListSkillsStoreSkillsByCategoryResponse {
        val op = SdkHttpOperation.build<ListSkillsStoreSkillsByCategoryRequest, ListSkillsStoreSkillsByCategoryResponse> {
            serializeWith = ListSkillsStoreSkillsByCategoryOperationSerializer()
            deserializeWith = ListSkillsStoreSkillsByCategoryOperationDeserializer()
            operationName = "ListSkillsStoreSkillsByCategory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the smart home appliances associated with a room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listSmartHomeAppliances(input: ListSmartHomeAppliancesRequest): ListSmartHomeAppliancesResponse {
        val op = SdkHttpOperation.build<ListSmartHomeAppliancesRequest, ListSmartHomeAppliancesResponse> {
            serializeWith = ListSmartHomeAppliancesOperationSerializer()
            deserializeWith = ListSmartHomeAppliancesOperationDeserializer()
            operationName = "ListSmartHomeAppliances"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags for the specified resource.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun listTags(input: ListTagsRequest): ListTagsResponse {
        val op = SdkHttpOperation.build<ListTagsRequest, ListTagsResponse> {
            serializeWith = ListTagsOperationSerializer()
            deserializeWith = ListTagsOperationDeserializer()
            operationName = "ListTags"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets the conference preferences on a specific conference provider at the account level.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun putConferencePreference(input: PutConferencePreferenceRequest): PutConferencePreferenceResponse {
        val op = SdkHttpOperation.build<PutConferencePreferenceRequest, PutConferencePreferenceResponse> {
            serializeWith = PutConferencePreferenceOperationSerializer()
            deserializeWith = PutConferencePreferenceOperationDeserializer()
            operationName = "PutConferencePreference"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Configures the email template for the user enrollment invitation with the specified attributes.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun putInvitationConfiguration(input: PutInvitationConfigurationRequest): PutInvitationConfigurationResponse {
        val op = SdkHttpOperation.build<PutInvitationConfigurationRequest, PutInvitationConfigurationResponse> {
            serializeWith = PutInvitationConfigurationOperationSerializer()
            deserializeWith = PutInvitationConfigurationOperationDeserializer()
            operationName = "PutInvitationConfiguration"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill parameter.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun putRoomSkillParameter(input: PutRoomSkillParameterRequest): PutRoomSkillParameterResponse {
        val op = SdkHttpOperation.build<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse> {
            serializeWith = PutRoomSkillParameterOperationSerializer()
            deserializeWith = PutRoomSkillParameterOperationDeserializer()
            operationName = "PutRoomSkillParameter"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role, the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the IAM role.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun putSkillAuthorization(input: PutSkillAuthorizationRequest): PutSkillAuthorizationResponse {
        val op = SdkHttpOperation.build<PutSkillAuthorizationRequest, PutSkillAuthorizationResponse> {
            serializeWith = PutSkillAuthorizationOperationSerializer()
            deserializeWith = PutSkillAuthorizationOperationDeserializer()
            operationName = "PutSkillAuthorization"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service (AVS).
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun registerAvsDevice(input: RegisterAvsDeviceRequest): RegisterAvsDeviceResponse {
        val op = SdkHttpOperation.build<RegisterAvsDeviceRequest, RegisterAvsDeviceResponse> {
            serializeWith = RegisterAVSDeviceOperationSerializer()
            deserializeWith = RegisterAVSDeviceOperationDeserializer()
            operationName = "RegisterAVSDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the ApproveSkill API.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun rejectSkill(input: RejectSkillRequest): RejectSkillResponse {
        val op = SdkHttpOperation.build<RejectSkillRequest, RejectSkillResponse> {
            serializeWith = RejectSkillOperationSerializer()
            deserializeWith = RejectSkillOperationDeserializer()
            operationName = "RejectSkill"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill developers.
     *
     * To query ResolveRoom from an Alexa skill, the skill ID needs to be authorized. When the skill is using an AWS Lambda function, the skill is automatically authorized when you publish your skill as a private skill to your AWS account. Skills that are hosted using a custom web service must be manually authorized. To get your skill authorized, contact AWS Support with your AWS account ID that queries the ResolveRoom API and skill ID.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun resolveRoom(input: ResolveRoomRequest): ResolveRoomResponse {
        val op = SdkHttpOperation.build<ResolveRoomRequest, ResolveRoomResponse> {
            serializeWith = ResolveRoomOperationSerializer()
            deserializeWith = ResolveRoomOperationDeserializer()
            operationName = "ResolveRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Revokes an invitation and invalidates the enrollment URL.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun revokeInvitation(input: RevokeInvitationRequest): RevokeInvitationResponse {
        val op = SdkHttpOperation.build<RevokeInvitationRequest, RevokeInvitationResponse> {
            serializeWith = RevokeInvitationOperationSerializer()
            deserializeWith = RevokeInvitationOperationDeserializer()
            operationName = "RevokeInvitation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchAddressBooks(input: SearchAddressBooksRequest): SearchAddressBooksResponse {
        val op = SdkHttpOperation.build<SearchAddressBooksRequest, SearchAddressBooksResponse> {
            serializeWith = SearchAddressBooksOperationSerializer()
            deserializeWith = SearchAddressBooksOperationDeserializer()
            operationName = "SearchAddressBooks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchContacts(input: SearchContactsRequest): SearchContactsResponse {
        val op = SdkHttpOperation.build<SearchContactsRequest, SearchContactsResponse> {
            serializeWith = SearchContactsOperationSerializer()
            deserializeWith = SearchContactsOperationDeserializer()
            operationName = "SearchContacts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches devices and lists the ones that meet a set of filter criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchDevices(input: SearchDevicesRequest): SearchDevicesResponse {
        val op = SdkHttpOperation.build<SearchDevicesRequest, SearchDevicesResponse> {
            serializeWith = SearchDevicesOperationSerializer()
            deserializeWith = SearchDevicesOperationDeserializer()
            operationName = "SearchDevices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchNetworkProfiles(input: SearchNetworkProfilesRequest): SearchNetworkProfilesResponse {
        val op = SdkHttpOperation.build<SearchNetworkProfilesRequest, SearchNetworkProfilesResponse> {
            serializeWith = SearchNetworkProfilesOperationSerializer()
            deserializeWith = SearchNetworkProfilesOperationDeserializer()
            operationName = "SearchNetworkProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchProfiles(input: SearchProfilesRequest): SearchProfilesResponse {
        val op = SdkHttpOperation.build<SearchProfilesRequest, SearchProfilesResponse> {
            serializeWith = SearchProfilesOperationSerializer()
            deserializeWith = SearchProfilesOperationDeserializer()
            operationName = "SearchProfiles"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchRooms(input: SearchRoomsRequest): SearchRoomsResponse {
        val op = SdkHttpOperation.build<SearchRoomsRequest, SearchRoomsResponse> {
            serializeWith = SearchRoomsOperationSerializer()
            deserializeWith = SearchRoomsOperationDeserializer()
            operationName = "SearchRooms"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchSkillGroups(input: SearchSkillGroupsRequest): SearchSkillGroupsResponse {
        val op = SdkHttpOperation.build<SearchSkillGroupsRequest, SearchSkillGroupsResponse> {
            serializeWith = SearchSkillGroupsOperationSerializer()
            deserializeWith = SearchSkillGroupsOperationDeserializer()
            operationName = "SearchSkillGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun searchUsers(input: SearchUsersRequest): SearchUsersResponse {
        val op = SdkHttpOperation.build<SearchUsersRequest, SearchUsersResponse> {
            serializeWith = SearchUsersOperationSerializer()
            deserializeWith = SearchUsersOperationDeserializer()
            operationName = "SearchUsers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search or filter.
     */
    override suspend fun sendAnnouncement(input: SendAnnouncementRequest): SendAnnouncementResponse {
        val op = SdkHttpOperation.build<SendAnnouncementRequest, SendAnnouncementResponse> {
            serializeWith = SendAnnouncementOperationSerializer()
            deserializeWith = SendAnnouncementOperationDeserializer()
            operationName = "SendAnnouncement"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this operation again, whichever comes first.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun sendInvitation(input: SendInvitationRequest): SendInvitationResponse {
        val op = SdkHttpOperation.build<SendInvitationRequest, SendInvitationResponse> {
            serializeWith = SendInvitationOperationSerializer()
            deserializeWith = SendInvitationOperationDeserializer()
            operationName = "SendInvitation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Resets a device and its account to the known default settings. This clears all information and settings set by previous users in the following ways:
     * + Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * + Volume - This resets the echo device's volume to the default value.
     * + Notifications - This clears all notifications from your echo device.
     * + Lists - This clears all to-do items from your echo device.
     * + Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address books, delegation access for account linking, and communications (if enabled on the room profile).
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun startDeviceSync(input: StartDeviceSyncRequest): StartDeviceSyncResponse {
        val op = SdkHttpOperation.build<StartDeviceSyncRequest, StartDeviceSyncResponse> {
            serializeWith = StartDeviceSyncOperationSerializer()
            deserializeWith = StartDeviceSyncOperationDeserializer()
            operationName = "StartDeviceSync"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Initiates the discovery of any smart home appliances associated with the room.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun startSmartHomeApplianceDiscovery(input: StartSmartHomeApplianceDiscoveryRequest): StartSmartHomeApplianceDiscoveryResponse {
        val op = SdkHttpOperation.build<StartSmartHomeApplianceDiscoveryRequest, StartSmartHomeApplianceDiscoveryResponse> {
            serializeWith = StartSmartHomeApplianceDiscoveryOperationSerializer()
            deserializeWith = StartSmartHomeApplianceDiscoveryOperationDeserializer()
            operationName = "StartSmartHomeApplianceDiscovery"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Adds metadata tags to a specified resource.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes metadata tags from a specified resource.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates address book details by the address book ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateAddressBook(input: UpdateAddressBookRequest): UpdateAddressBookResponse {
        val op = SdkHttpOperation.build<UpdateAddressBookRequest, UpdateAddressBookResponse> {
            serializeWith = UpdateAddressBookOperationSerializer()
            deserializeWith = UpdateAddressBookOperationDeserializer()
            operationName = "UpdateAddressBook"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateBusinessReportSchedule(input: UpdateBusinessReportScheduleRequest): UpdateBusinessReportScheduleResponse {
        val op = SdkHttpOperation.build<UpdateBusinessReportScheduleRequest, UpdateBusinessReportScheduleResponse> {
            serializeWith = UpdateBusinessReportScheduleOperationSerializer()
            deserializeWith = UpdateBusinessReportScheduleOperationDeserializer()
            operationName = "UpdateBusinessReportSchedule"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing conference provider's settings.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateConferenceProvider(input: UpdateConferenceProviderRequest): UpdateConferenceProviderResponse {
        val op = SdkHttpOperation.build<UpdateConferenceProviderRequest, UpdateConferenceProviderResponse> {
            serializeWith = UpdateConferenceProviderOperationSerializer()
            deserializeWith = UpdateConferenceProviderOperationDeserializer()
            operationName = "UpdateConferenceProvider"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the contact details by the contact ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializeWith = UpdateContactOperationSerializer()
            deserializeWith = UpdateContactOperationDeserializer()
            operationName = "UpdateContact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the device name by device ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse {
        val op = SdkHttpOperation.build<UpdateDeviceRequest, UpdateDeviceResponse> {
            serializeWith = UpdateDeviceOperationSerializer()
            deserializeWith = UpdateDeviceOperationDeserializer()
            operationName = "UpdateDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateGateway(input: UpdateGatewayRequest): UpdateGatewayResponse {
        val op = SdkHttpOperation.build<UpdateGatewayRequest, UpdateGatewayResponse> {
            serializeWith = UpdateGatewayOperationSerializer()
            deserializeWith = UpdateGatewayOperationDeserializer()
            operationName = "UpdateGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value is left unmodified.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateGatewayGroup(input: UpdateGatewayGroupRequest): UpdateGatewayGroupResponse {
        val op = SdkHttpOperation.build<UpdateGatewayGroupRequest, UpdateGatewayGroupResponse> {
            serializeWith = UpdateGatewayGroupOperationSerializer()
            deserializeWith = UpdateGatewayGroupOperationDeserializer()
            operationName = "UpdateGatewayGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a network profile by the network profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateNetworkProfile(input: UpdateNetworkProfileRequest): UpdateNetworkProfileResponse {
        val op = SdkHttpOperation.build<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse> {
            serializeWith = UpdateNetworkProfileOperationSerializer()
            deserializeWith = UpdateNetworkProfileOperationDeserializer()
            operationName = "UpdateNetworkProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing room profile by room profile ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse {
        val op = SdkHttpOperation.build<UpdateProfileRequest, UpdateProfileResponse> {
            serializeWith = UpdateProfileOperationSerializer()
            deserializeWith = UpdateProfileOperationDeserializer()
            operationName = "UpdateProfile"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates room details by room ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateRoom(input: UpdateRoomRequest): UpdateRoomResponse {
        val op = SdkHttpOperation.build<UpdateRoomRequest, UpdateRoomResponse> {
            serializeWith = UpdateRoomOperationSerializer()
            deserializeWith = UpdateRoomOperationDeserializer()
            operationName = "UpdateRoom"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates skill group details by skill group ARN.
     */
    @Deprecated("Alexa For Business is no longer supported")
    override suspend fun updateSkillGroup(input: UpdateSkillGroupRequest): UpdateSkillGroupResponse {
        val op = SdkHttpOperation.build<UpdateSkillGroupRequest, UpdateSkillGroupResponse> {
            serializeWith = UpdateSkillGroupOperationSerializer()
            deserializeWith = UpdateSkillGroupOperationDeserializer()
            operationName = "UpdateSkillGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AlexaForBusiness", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "a4b")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
