// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AssociateDeviceWithNetworkProfileOperationDeserializer: HttpDeserializer.NonStreaming<AssociateDeviceWithNetworkProfileResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssociateDeviceWithNetworkProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssociateDeviceWithNetworkProfileError(context, call, payload)
        }
        val builder = AssociateDeviceWithNetworkProfileResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssociateDeviceWithNetworkProfileError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConcurrentModificationException" -> ConcurrentModificationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeviceNotRegisteredException" -> DeviceNotRegisteredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
