// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.alexaforbusiness.serde

import aws.sdk.kotlin.services.alexaforbusiness.model.AlexaForBusinessException
import aws.sdk.kotlin.services.alexaforbusiness.model.ContactData
import aws.sdk.kotlin.services.alexaforbusiness.model.SearchContactsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SearchContactsOperationDeserializer: HttpDeserializer.NonStreaming<SearchContactsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SearchContactsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSearchContactsError(context, call, payload)
        }
        val builder = SearchContactsResponse.Builder()

        if (payload != null) {
            deserializeSearchContactsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSearchContactsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AlexaForBusinessException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> AlexaForBusinessException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchContactsOperationBody(builder: SearchContactsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Contacts"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val TOTALCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TOTALCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTS_DESCRIPTOR.index -> builder.contacts =
                    deserializer.deserializeList(CONTACTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ContactData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContactDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TOTALCOUNT_DESCRIPTOR.index -> builder.totalCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
