// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplifybackend.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.amplifybackend.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Amplify Admin API
 */
interface AmplifyBackendClient : SdkClient {

    override val serviceName: String
        get() = "AmplifyBackend"
    /**
     * AmplifyBackendClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): AmplifyBackendClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyBackendClient(config)
        }

        operator fun invoke(config: Config): AmplifyBackendClient = DefaultAmplifyBackendClient(config)

        /**
         * Construct a [AmplifyBackendClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyBackendClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultAmplifyBackendClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This operation clones an existing backend.
     */
    suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse

    /**
     * This operation clones an existing backend.
     */
    suspend fun cloneBackend(block: CloneBackendRequest.Builder.() -> Unit) = cloneBackend(CloneBackendRequest.Builder().apply(block).build())

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    suspend fun createBackend(block: CreateBackendRequest.Builder.() -> Unit) = createBackend(CreateBackendRequest.Builder().apply(block).build())

    /**
     * Creates a new backend API resource.
     */
    suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse

    /**
     * Creates a new backend API resource.
     */
    suspend fun createBackendApi(block: CreateBackendApiRequest.Builder.() -> Unit) = createBackendApi(CreateBackendApiRequest.Builder().apply(block).build())

    /**
     * Creates a new backend authentication resource.
     */
    suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse

    /**
     * Creates a new backend authentication resource.
     */
    suspend fun createBackendAuth(block: CreateBackendAuthRequest.Builder.() -> Unit) = createBackendAuth(CreateBackendAuthRequest.Builder().apply(block).build())

    /**
     * Creates a config object for a backend.
     */
    suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse

    /**
     * Creates a config object for a backend.
     */
    suspend fun createBackendConfig(block: CreateBackendConfigRequest.Builder.() -> Unit) = createBackendConfig(CreateBackendConfigRequest.Builder().apply(block).build())

    /**
     * Creates a backend storage resource.
     */
    suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse

    /**
     * Creates a backend storage resource.
     */
    suspend fun createBackendStorage(block: CreateBackendStorageRequest.Builder.() -> Unit) = createBackendStorage(CreateBackendStorageRequest.Builder().apply(block).build())

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    suspend fun createToken(block: CreateTokenRequest.Builder.() -> Unit) = createToken(CreateTokenRequest.Builder().apply(block).build())

    /**
     * Removes an existing environment from your Amplify project.
     */
    suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse

    /**
     * Removes an existing environment from your Amplify project.
     */
    suspend fun deleteBackend(block: DeleteBackendRequest.Builder.() -> Unit) = deleteBackend(DeleteBackendRequest.Builder().apply(block).build())

    /**
     * Deletes an existing backend API resource.
     */
    suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse

    /**
     * Deletes an existing backend API resource.
     */
    suspend fun deleteBackendApi(block: DeleteBackendApiRequest.Builder.() -> Unit) = deleteBackendApi(DeleteBackendApiRequest.Builder().apply(block).build())

    /**
     * Deletes an existing backend authentication resource.
     */
    suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse

    /**
     * Deletes an existing backend authentication resource.
     */
    suspend fun deleteBackendAuth(block: DeleteBackendAuthRequest.Builder.() -> Unit) = deleteBackendAuth(DeleteBackendAuthRequest.Builder().apply(block).build())

    /**
     * Removes the specified backend storage resource.
     */
    suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse

    /**
     * Removes the specified backend storage resource.
     */
    suspend fun deleteBackendStorage(block: DeleteBackendStorageRequest.Builder.() -> Unit) = deleteBackendStorage(DeleteBackendStorageRequest.Builder().apply(block).build())

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    suspend fun deleteToken(block: DeleteTokenRequest.Builder.() -> Unit) = deleteToken(DeleteTokenRequest.Builder().apply(block).build())

    /**
     * Generates a model schema for an existing backend API resource.
     */
    suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse

    /**
     * Generates a model schema for an existing backend API resource.
     */
    suspend fun generateBackendApiModels(block: GenerateBackendApiModelsRequest.Builder.() -> Unit) = generateBackendApiModels(GenerateBackendApiModelsRequest.Builder().apply(block).build())

    /**
     * Provides project-level details for your Amplify UI project.
     */
    suspend fun getBackend(input: GetBackendRequest): GetBackendResponse

    /**
     * Provides project-level details for your Amplify UI project.
     */
    suspend fun getBackend(block: GetBackendRequest.Builder.() -> Unit) = getBackend(GetBackendRequest.Builder().apply(block).build())

    /**
     * Gets the details for a backend API.
     */
    suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse

    /**
     * Gets the details for a backend API.
     */
    suspend fun getBackendApi(block: GetBackendApiRequest.Builder.() -> Unit) = getBackendApi(GetBackendApiRequest.Builder().apply(block).build())

    /**
     * Generates a model schema for existing backend API resource.
     */
    suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse

    /**
     * Generates a model schema for existing backend API resource.
     */
    suspend fun getBackendApiModels(block: GetBackendApiModelsRequest.Builder.() -> Unit) = getBackendApiModels(GetBackendApiModelsRequest.Builder().apply(block).build())

    /**
     * Gets a backend auth details.
     */
    suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse

    /**
     * Gets a backend auth details.
     */
    suspend fun getBackendAuth(block: GetBackendAuthRequest.Builder.() -> Unit) = getBackendAuth(GetBackendAuthRequest.Builder().apply(block).build())

    /**
     * Returns information about a specific job.
     */
    suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse

    /**
     * Returns information about a specific job.
     */
    suspend fun getBackendJob(block: GetBackendJobRequest.Builder.() -> Unit) = getBackendJob(GetBackendJobRequest.Builder().apply(block).build())

    /**
     * Gets details for a backend storage resource.
     */
    suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse

    /**
     * Gets details for a backend storage resource.
     */
    suspend fun getBackendStorage(block: GetBackendStorageRequest.Builder.() -> Unit) = getBackendStorage(GetBackendStorageRequest.Builder().apply(block).build())

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    suspend fun getToken(input: GetTokenRequest): GetTokenResponse

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    suspend fun getToken(block: GetTokenRequest.Builder.() -> Unit) = getToken(GetTokenRequest.Builder().apply(block).build())

    /**
     * Imports an existing backend authentication resource.
     */
    suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse

    /**
     * Imports an existing backend authentication resource.
     */
    suspend fun importBackendAuth(block: ImportBackendAuthRequest.Builder.() -> Unit) = importBackendAuth(ImportBackendAuthRequest.Builder().apply(block).build())

    /**
     * Imports an existing backend storage resource.
     */
    suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse

    /**
     * Imports an existing backend storage resource.
     */
    suspend fun importBackendStorage(block: ImportBackendStorageRequest.Builder.() -> Unit) = importBackendStorage(ImportBackendStorageRequest.Builder().apply(block).build())

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    suspend fun listBackendJobs(block: ListBackendJobsRequest.Builder.() -> Unit) = listBackendJobs(ListBackendJobsRequest.Builder().apply(block).build())

    /**
     * The list of S3 buckets in your account.
     */
    suspend fun listS3Buckets(input: ListS3BucketsRequest = ListS3BucketsRequest {}): ListS3BucketsResponse

    /**
     * The list of S3 buckets in your account.
     */
    suspend fun listS3Buckets(block: ListS3BucketsRequest.Builder.() -> Unit) = listS3Buckets(ListS3BucketsRequest.Builder().apply(block).build())

    /**
     * Removes all backend environments from your Amplify project.
     */
    suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse

    /**
     * Removes all backend environments from your Amplify project.
     */
    suspend fun removeAllBackends(block: RemoveAllBackendsRequest.Builder.() -> Unit) = removeAllBackends(RemoveAllBackendsRequest.Builder().apply(block).build())

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun removeBackendConfig(block: RemoveBackendConfigRequest.Builder.() -> Unit) = removeBackendConfig(RemoveBackendConfigRequest.Builder().apply(block).build())

    /**
     * Updates an existing backend API resource.
     */
    suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse

    /**
     * Updates an existing backend API resource.
     */
    suspend fun updateBackendApi(block: UpdateBackendApiRequest.Builder.() -> Unit) = updateBackendApi(UpdateBackendApiRequest.Builder().apply(block).build())

    /**
     * Updates an existing backend authentication resource.
     */
    suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse

    /**
     * Updates an existing backend authentication resource.
     */
    suspend fun updateBackendAuth(block: UpdateBackendAuthRequest.Builder.() -> Unit) = updateBackendAuth(UpdateBackendAuthRequest.Builder().apply(block).build())

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun updateBackendConfig(block: UpdateBackendConfigRequest.Builder.() -> Unit) = updateBackendConfig(UpdateBackendConfigRequest.Builder().apply(block).build())

    /**
     * Updates a specific job.
     */
    suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse

    /**
     * Updates a specific job.
     */
    suspend fun updateBackendJob(block: UpdateBackendJobRequest.Builder.() -> Unit) = updateBackendJob(UpdateBackendJobRequest.Builder().apply(block).build())

    /**
     * Updates an existing backend storage resource.
     */
    suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse

    /**
     * Updates an existing backend storage resource.
     */
    suspend fun updateBackendStorage(block: UpdateBackendStorageRequest.Builder.() -> Unit) = updateBackendStorage(UpdateBackendStorageRequest.Builder().apply(block).build())
}
