// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplifybackend.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.amplifybackend.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Amplify Admin API
 */
interface AmplifyBackendClient : SdkClient {

    override val serviceName: String
        get() = "AmplifyBackend"
    /**
     * AmplifyBackendClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): AmplifyBackendClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyBackendClient(config)
        }

        operator fun invoke(config: Config): AmplifyBackendClient = DefaultAmplifyBackendClient(config)

        /**
         * Construct a [AmplifyBackendClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyBackendClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultAmplifyBackendClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This operation clones an existing backend.
     */
    suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse

    /**
     * Creates a new backend API resource.
     */
    suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse

    /**
     * Creates a new backend authentication resource.
     */
    suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse

    /**
     * Creates a config object for a backend.
     */
    suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse

    /**
     * Creates a backend storage resource.
     */
    suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse

    /**
     * Removes an existing environment from your Amplify project.
     */
    suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse

    /**
     * Deletes an existing backend API resource.
     */
    suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse

    /**
     * Deletes an existing backend authentication resource.
     */
    suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse

    /**
     * Removes the specified backend storage resource.
     */
    suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse

    /**
     * Generates a model schema for an existing backend API resource.
     */
    suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse

    /**
     * Provides project-level details for your Amplify UI project.
     */
    suspend fun getBackend(input: GetBackendRequest): GetBackendResponse

    /**
     * Gets the details for a backend API.
     */
    suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse

    /**
     * Generates a model schema for existing backend API resource.
     */
    suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse

    /**
     * Gets a backend auth details.
     */
    suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse

    /**
     * Returns information about a specific job.
     */
    suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse

    /**
     * Gets details for a backend storage resource.
     */
    suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    suspend fun getToken(input: GetTokenRequest): GetTokenResponse

    /**
     * Imports an existing backend authentication resource.
     */
    suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse

    /**
     * Imports an existing backend storage resource.
     */
    suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse

    /**
     * The list of S3 buckets in your account.
     */
    suspend fun listS3Buckets(input: ListS3BucketsRequest = ListS3BucketsRequest {}): ListS3BucketsResponse

    /**
     * Removes all backend environments from your Amplify project.
     */
    suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse

    /**
     * Updates an existing backend API resource.
     */
    suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse

    /**
     * Updates an existing backend authentication resource.
     */
    suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse

    /**
     * Updates a specific job.
     */
    suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse

    /**
     * Updates an existing backend storage resource.
     */
    suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse
}

/**
 * This operation clones an existing backend.
 */
suspend inline fun AmplifyBackendClient.cloneBackend(crossinline block: CloneBackendRequest.Builder.() -> Unit) = cloneBackend(CloneBackendRequest.Builder().apply(block).build())

/**
 * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
 */
suspend inline fun AmplifyBackendClient.createBackend(crossinline block: CreateBackendRequest.Builder.() -> Unit) = createBackend(CreateBackendRequest.Builder().apply(block).build())

/**
 * Creates a new backend API resource.
 */
suspend inline fun AmplifyBackendClient.createBackendApi(crossinline block: CreateBackendApiRequest.Builder.() -> Unit) = createBackendApi(CreateBackendApiRequest.Builder().apply(block).build())

/**
 * Creates a new backend authentication resource.
 */
suspend inline fun AmplifyBackendClient.createBackendAuth(crossinline block: CreateBackendAuthRequest.Builder.() -> Unit) = createBackendAuth(CreateBackendAuthRequest.Builder().apply(block).build())

/**
 * Creates a config object for a backend.
 */
suspend inline fun AmplifyBackendClient.createBackendConfig(crossinline block: CreateBackendConfigRequest.Builder.() -> Unit) = createBackendConfig(CreateBackendConfigRequest.Builder().apply(block).build())

/**
 * Creates a backend storage resource.
 */
suspend inline fun AmplifyBackendClient.createBackendStorage(crossinline block: CreateBackendStorageRequest.Builder.() -> Unit) = createBackendStorage(CreateBackendStorageRequest.Builder().apply(block).build())

/**
 * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
 */
suspend inline fun AmplifyBackendClient.createToken(crossinline block: CreateTokenRequest.Builder.() -> Unit) = createToken(CreateTokenRequest.Builder().apply(block).build())

/**
 * Removes an existing environment from your Amplify project.
 */
suspend inline fun AmplifyBackendClient.deleteBackend(crossinline block: DeleteBackendRequest.Builder.() -> Unit) = deleteBackend(DeleteBackendRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend API resource.
 */
suspend inline fun AmplifyBackendClient.deleteBackendApi(crossinline block: DeleteBackendApiRequest.Builder.() -> Unit) = deleteBackendApi(DeleteBackendApiRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend authentication resource.
 */
suspend inline fun AmplifyBackendClient.deleteBackendAuth(crossinline block: DeleteBackendAuthRequest.Builder.() -> Unit) = deleteBackendAuth(DeleteBackendAuthRequest.Builder().apply(block).build())

/**
 * Removes the specified backend storage resource.
 */
suspend inline fun AmplifyBackendClient.deleteBackendStorage(crossinline block: DeleteBackendStorageRequest.Builder.() -> Unit) = deleteBackendStorage(DeleteBackendStorageRequest.Builder().apply(block).build())

/**
 * Deletes the challenge token based on the given appId and sessionId.
 */
suspend inline fun AmplifyBackendClient.deleteToken(crossinline block: DeleteTokenRequest.Builder.() -> Unit) = deleteToken(DeleteTokenRequest.Builder().apply(block).build())

/**
 * Generates a model schema for an existing backend API resource.
 */
suspend inline fun AmplifyBackendClient.generateBackendApiModels(crossinline block: GenerateBackendApiModelsRequest.Builder.() -> Unit) = generateBackendApiModels(GenerateBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Provides project-level details for your Amplify UI project.
 */
suspend inline fun AmplifyBackendClient.getBackend(crossinline block: GetBackendRequest.Builder.() -> Unit) = getBackend(GetBackendRequest.Builder().apply(block).build())

/**
 * Gets the details for a backend API.
 */
suspend inline fun AmplifyBackendClient.getBackendApi(crossinline block: GetBackendApiRequest.Builder.() -> Unit) = getBackendApi(GetBackendApiRequest.Builder().apply(block).build())

/**
 * Generates a model schema for existing backend API resource.
 */
suspend inline fun AmplifyBackendClient.getBackendApiModels(crossinline block: GetBackendApiModelsRequest.Builder.() -> Unit) = getBackendApiModels(GetBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Gets a backend auth details.
 */
suspend inline fun AmplifyBackendClient.getBackendAuth(crossinline block: GetBackendAuthRequest.Builder.() -> Unit) = getBackendAuth(GetBackendAuthRequest.Builder().apply(block).build())

/**
 * Returns information about a specific job.
 */
suspend inline fun AmplifyBackendClient.getBackendJob(crossinline block: GetBackendJobRequest.Builder.() -> Unit) = getBackendJob(GetBackendJobRequest.Builder().apply(block).build())

/**
 * Gets details for a backend storage resource.
 */
suspend inline fun AmplifyBackendClient.getBackendStorage(crossinline block: GetBackendStorageRequest.Builder.() -> Unit) = getBackendStorage(GetBackendStorageRequest.Builder().apply(block).build())

/**
 * Gets the challenge token based on the given appId and sessionId.
 */
suspend inline fun AmplifyBackendClient.getToken(crossinline block: GetTokenRequest.Builder.() -> Unit) = getToken(GetTokenRequest.Builder().apply(block).build())

/**
 * Imports an existing backend authentication resource.
 */
suspend inline fun AmplifyBackendClient.importBackendAuth(crossinline block: ImportBackendAuthRequest.Builder.() -> Unit) = importBackendAuth(ImportBackendAuthRequest.Builder().apply(block).build())

/**
 * Imports an existing backend storage resource.
 */
suspend inline fun AmplifyBackendClient.importBackendStorage(crossinline block: ImportBackendStorageRequest.Builder.() -> Unit) = importBackendStorage(ImportBackendStorageRequest.Builder().apply(block).build())

/**
 * Lists the jobs for the backend of an Amplify app.
 */
suspend inline fun AmplifyBackendClient.listBackendJobs(crossinline block: ListBackendJobsRequest.Builder.() -> Unit) = listBackendJobs(ListBackendJobsRequest.Builder().apply(block).build())

/**
 * The list of S3 buckets in your account.
 */
suspend inline fun AmplifyBackendClient.listS3Buckets(crossinline block: ListS3BucketsRequest.Builder.() -> Unit) = listS3Buckets(ListS3BucketsRequest.Builder().apply(block).build())

/**
 * Removes all backend environments from your Amplify project.
 */
suspend inline fun AmplifyBackendClient.removeAllBackends(crossinline block: RemoveAllBackendsRequest.Builder.() -> Unit) = removeAllBackends(RemoveAllBackendsRequest.Builder().apply(block).build())

/**
 * Removes the AWS resources required to access the Amplify Admin UI.
 */
suspend inline fun AmplifyBackendClient.removeBackendConfig(crossinline block: RemoveBackendConfigRequest.Builder.() -> Unit) = removeBackendConfig(RemoveBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing backend API resource.
 */
suspend inline fun AmplifyBackendClient.updateBackendApi(crossinline block: UpdateBackendApiRequest.Builder.() -> Unit) = updateBackendApi(UpdateBackendApiRequest.Builder().apply(block).build())

/**
 * Updates an existing backend authentication resource.
 */
suspend inline fun AmplifyBackendClient.updateBackendAuth(crossinline block: UpdateBackendAuthRequest.Builder.() -> Unit) = updateBackendAuth(UpdateBackendAuthRequest.Builder().apply(block).build())

/**
 * Updates the AWS resources required to access the Amplify Admin UI.
 */
suspend inline fun AmplifyBackendClient.updateBackendConfig(crossinline block: UpdateBackendConfigRequest.Builder.() -> Unit) = updateBackendConfig(UpdateBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates a specific job.
 */
suspend inline fun AmplifyBackendClient.updateBackendJob(crossinline block: UpdateBackendJobRequest.Builder.() -> Unit) = updateBackendJob(UpdateBackendJobRequest.Builder().apply(block).build())

/**
 * Updates an existing backend storage resource.
 */
suspend inline fun AmplifyBackendClient.updateBackendStorage(crossinline block: UpdateBackendStorageRequest.Builder.() -> Unit) = updateBackendStorage(UpdateBackendStorageRequest.Builder().apply(block).build())
