// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplifybackend.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.amplifybackend.model.*
import aws.sdk.kotlin.services.amplifybackend.model.CloneBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CloneBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.GenerateBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GenerateBackendApiModelsResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiModelsResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendJobResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.ListBackendJobsRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListBackendJobsResponse
import aws.sdk.kotlin.services.amplifybackend.model.ListS3BucketsRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListS3BucketsResponse
import aws.sdk.kotlin.services.amplifybackend.model.RemoveAllBackendsRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveAllBackendsResponse
import aws.sdk.kotlin.services.amplifybackend.model.RemoveBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendJobResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendStorageResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * AWS Amplify Admin API
 */
public interface AmplifyBackendClient : SdkClient {

    override val serviceName: String
        get() = "AmplifyBackend"
    /**
     * AmplifyBackendClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AmplifyBackendClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyBackendClient(config)
        }

        public operator fun invoke(config: Config): AmplifyBackendClient = DefaultAmplifyBackendClient(config)

        /**
         * Construct a [AmplifyBackendClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyBackendClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultAmplifyBackendClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This operation clones an existing backend.
     */
    public suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    public suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse

    /**
     * Creates a new backend API resource.
     */
    public suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse

    /**
     * Creates a new backend authentication resource.
     */
    public suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse

    /**
     * Creates a config object for a backend.
     */
    public suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse

    /**
     * Creates a backend storage resource.
     */
    public suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    public suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse

    /**
     * Removes an existing environment from your Amplify project.
     */
    public suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse

    /**
     * Deletes an existing backend API resource.
     */
    public suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse

    /**
     * Deletes an existing backend authentication resource.
     */
    public suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse

    /**
     * Removes the specified backend storage resource.
     */
    public suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    public suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse

    /**
     * Generates a model schema for an existing backend API resource.
     */
    public suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse

    /**
     * Provides project-level details for your Amplify UI project.
     */
    public suspend fun getBackend(input: GetBackendRequest): GetBackendResponse

    /**
     * Gets the details for a backend API.
     */
    public suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse

    /**
     * Generates a model schema for existing backend API resource.
     */
    public suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse

    /**
     * Gets a backend auth details.
     */
    public suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse

    /**
     * Returns information about a specific job.
     */
    public suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse

    /**
     * Gets details for a backend storage resource.
     */
    public suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    public suspend fun getToken(input: GetTokenRequest): GetTokenResponse

    /**
     * Imports an existing backend authentication resource.
     */
    public suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse

    /**
     * Imports an existing backend storage resource.
     */
    public suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    public suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse

    /**
     * The list of S3 buckets in your account.
     */
    public suspend fun listS3Buckets(input: ListS3BucketsRequest = ListS3BucketsRequest {}): ListS3BucketsResponse

    /**
     * Removes all backend environments from your Amplify project.
     */
    public suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    public suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse

    /**
     * Updates an existing backend API resource.
     */
    public suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse

    /**
     * Updates an existing backend authentication resource.
     */
    public suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    public suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse

    /**
     * Updates a specific job.
     */
    public suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse

    /**
     * Updates an existing backend storage resource.
     */
    public suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse
}

/**
 * This operation clones an existing backend.
 */
public suspend inline fun AmplifyBackendClient.cloneBackend(crossinline block: CloneBackendRequest.Builder.() -> Unit): CloneBackendResponse = cloneBackend(CloneBackendRequest.Builder().apply(block).build())

/**
 * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
 */
public suspend inline fun AmplifyBackendClient.createBackend(crossinline block: CreateBackendRequest.Builder.() -> Unit): CreateBackendResponse = createBackend(CreateBackendRequest.Builder().apply(block).build())

/**
 * Creates a new backend API resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendApi(crossinline block: CreateBackendApiRequest.Builder.() -> Unit): CreateBackendApiResponse = createBackendApi(CreateBackendApiRequest.Builder().apply(block).build())

/**
 * Creates a new backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendAuth(crossinline block: CreateBackendAuthRequest.Builder.() -> Unit): CreateBackendAuthResponse = createBackendAuth(CreateBackendAuthRequest.Builder().apply(block).build())

/**
 * Creates a config object for a backend.
 */
public suspend inline fun AmplifyBackendClient.createBackendConfig(crossinline block: CreateBackendConfigRequest.Builder.() -> Unit): CreateBackendConfigResponse = createBackendConfig(CreateBackendConfigRequest.Builder().apply(block).build())

/**
 * Creates a backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendStorage(crossinline block: CreateBackendStorageRequest.Builder.() -> Unit): CreateBackendStorageResponse = createBackendStorage(CreateBackendStorageRequest.Builder().apply(block).build())

/**
 * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.createToken(crossinline block: CreateTokenRequest.Builder.() -> Unit): CreateTokenResponse = createToken(CreateTokenRequest.Builder().apply(block).build())

/**
 * Removes an existing environment from your Amplify project.
 */
public suspend inline fun AmplifyBackendClient.deleteBackend(crossinline block: DeleteBackendRequest.Builder.() -> Unit): DeleteBackendResponse = deleteBackend(DeleteBackendRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendApi(crossinline block: DeleteBackendApiRequest.Builder.() -> Unit): DeleteBackendApiResponse = deleteBackendApi(DeleteBackendApiRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendAuth(crossinline block: DeleteBackendAuthRequest.Builder.() -> Unit): DeleteBackendAuthResponse = deleteBackendAuth(DeleteBackendAuthRequest.Builder().apply(block).build())

/**
 * Removes the specified backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendStorage(crossinline block: DeleteBackendStorageRequest.Builder.() -> Unit): DeleteBackendStorageResponse = deleteBackendStorage(DeleteBackendStorageRequest.Builder().apply(block).build())

/**
 * Deletes the challenge token based on the given appId and sessionId.
 */
public suspend inline fun AmplifyBackendClient.deleteToken(crossinline block: DeleteTokenRequest.Builder.() -> Unit): DeleteTokenResponse = deleteToken(DeleteTokenRequest.Builder().apply(block).build())

/**
 * Generates a model schema for an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.generateBackendApiModels(crossinline block: GenerateBackendApiModelsRequest.Builder.() -> Unit): GenerateBackendApiModelsResponse = generateBackendApiModels(GenerateBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Provides project-level details for your Amplify UI project.
 */
public suspend inline fun AmplifyBackendClient.getBackend(crossinline block: GetBackendRequest.Builder.() -> Unit): GetBackendResponse = getBackend(GetBackendRequest.Builder().apply(block).build())

/**
 * Gets the details for a backend API.
 */
public suspend inline fun AmplifyBackendClient.getBackendApi(crossinline block: GetBackendApiRequest.Builder.() -> Unit): GetBackendApiResponse = getBackendApi(GetBackendApiRequest.Builder().apply(block).build())

/**
 * Generates a model schema for existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.getBackendApiModels(crossinline block: GetBackendApiModelsRequest.Builder.() -> Unit): GetBackendApiModelsResponse = getBackendApiModels(GetBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Gets a backend auth details.
 */
public suspend inline fun AmplifyBackendClient.getBackendAuth(crossinline block: GetBackendAuthRequest.Builder.() -> Unit): GetBackendAuthResponse = getBackendAuth(GetBackendAuthRequest.Builder().apply(block).build())

/**
 * Returns information about a specific job.
 */
public suspend inline fun AmplifyBackendClient.getBackendJob(crossinline block: GetBackendJobRequest.Builder.() -> Unit): GetBackendJobResponse = getBackendJob(GetBackendJobRequest.Builder().apply(block).build())

/**
 * Gets details for a backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.getBackendStorage(crossinline block: GetBackendStorageRequest.Builder.() -> Unit): GetBackendStorageResponse = getBackendStorage(GetBackendStorageRequest.Builder().apply(block).build())

/**
 * Gets the challenge token based on the given appId and sessionId.
 */
public suspend inline fun AmplifyBackendClient.getToken(crossinline block: GetTokenRequest.Builder.() -> Unit): GetTokenResponse = getToken(GetTokenRequest.Builder().apply(block).build())

/**
 * Imports an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.importBackendAuth(crossinline block: ImportBackendAuthRequest.Builder.() -> Unit): ImportBackendAuthResponse = importBackendAuth(ImportBackendAuthRequest.Builder().apply(block).build())

/**
 * Imports an existing backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.importBackendStorage(crossinline block: ImportBackendStorageRequest.Builder.() -> Unit): ImportBackendStorageResponse = importBackendStorage(ImportBackendStorageRequest.Builder().apply(block).build())

/**
 * Lists the jobs for the backend of an Amplify app.
 */
public suspend inline fun AmplifyBackendClient.listBackendJobs(crossinline block: ListBackendJobsRequest.Builder.() -> Unit): ListBackendJobsResponse = listBackendJobs(ListBackendJobsRequest.Builder().apply(block).build())

/**
 * The list of S3 buckets in your account.
 */
public suspend inline fun AmplifyBackendClient.listS3Buckets(crossinline block: ListS3BucketsRequest.Builder.() -> Unit): ListS3BucketsResponse = listS3Buckets(ListS3BucketsRequest.Builder().apply(block).build())

/**
 * Removes all backend environments from your Amplify project.
 */
public suspend inline fun AmplifyBackendClient.removeAllBackends(crossinline block: RemoveAllBackendsRequest.Builder.() -> Unit): RemoveAllBackendsResponse = removeAllBackends(RemoveAllBackendsRequest.Builder().apply(block).build())

/**
 * Removes the AWS resources required to access the Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.removeBackendConfig(crossinline block: RemoveBackendConfigRequest.Builder.() -> Unit): RemoveBackendConfigResponse = removeBackendConfig(RemoveBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendApi(crossinline block: UpdateBackendApiRequest.Builder.() -> Unit): UpdateBackendApiResponse = updateBackendApi(UpdateBackendApiRequest.Builder().apply(block).build())

/**
 * Updates an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendAuth(crossinline block: UpdateBackendAuthRequest.Builder.() -> Unit): UpdateBackendAuthResponse = updateBackendAuth(UpdateBackendAuthRequest.Builder().apply(block).build())

/**
 * Updates the AWS resources required to access the Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.updateBackendConfig(crossinline block: UpdateBackendConfigRequest.Builder.() -> Unit): UpdateBackendConfigResponse = updateBackendConfig(UpdateBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates a specific job.
 */
public suspend inline fun AmplifyBackendClient.updateBackendJob(crossinline block: UpdateBackendJobRequest.Builder.() -> Unit): UpdateBackendJobResponse = updateBackendJob(UpdateBackendJobRequest.Builder().apply(block).build())

/**
 * Updates an existing backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendStorage(crossinline block: UpdateBackendStorageRequest.Builder.() -> Unit): UpdateBackendStorageResponse = updateBackendStorage(UpdateBackendStorageRequest.Builder().apply(block).build())
