// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.amplifybackend.model.AmplifyBackendException
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetTokenOperationDeserializer: HttpDeserialize<GetTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTokenResponse {
        if (!response.status.isSuccess()) {
            throwGetTokenError(context, response)
        }
        val builder = GetTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyBackendException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AmplifyBackendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTokenOperationBody(builder: GetTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val CHALLENGECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("challengeCode"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ttl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPID_DESCRIPTOR)
        field(CHALLENGECODE_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                CHALLENGECODE_DESCRIPTOR.index -> builder.challengeCode = deserializeString()
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                TTL_DESCRIPTOR.index -> builder.ttl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
