// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.amplifybackend.model.AmplifyBackendException
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetBackendOperationDeserializer: HttpDeserialize<GetBackendResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBackendResponse {
        if (!response.status.isSuccess()) {
            throwGetBackendError(context, response)
        }
        val builder = GetBackendResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBackendOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBackendError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyBackendException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AmplifyBackendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBackendOperationBody(builder: GetBackendResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AMPLIFYFEATUREFLAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("amplifyFeatureFlags"))
    val AMPLIFYMETACONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("amplifyMetaConfig"))
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val APPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appName"))
    val BACKENDENVIRONMENTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("backendEnvironmentList"))
    val BACKENDENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendEnvironmentName"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AMPLIFYFEATUREFLAGS_DESCRIPTOR)
        field(AMPLIFYMETACONFIG_DESCRIPTOR)
        field(APPID_DESCRIPTOR)
        field(APPNAME_DESCRIPTOR)
        field(BACKENDENVIRONMENTLIST_DESCRIPTOR)
        field(BACKENDENVIRONMENTNAME_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AMPLIFYFEATUREFLAGS_DESCRIPTOR.index -> builder.amplifyFeatureFlags = deserializeString()
                AMPLIFYMETACONFIG_DESCRIPTOR.index -> builder.amplifyMetaConfig = deserializeString()
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                APPNAME_DESCRIPTOR.index -> builder.appName = deserializeString()
                BACKENDENVIRONMENTLIST_DESCRIPTOR.index -> builder.backendEnvironmentList =
                    deserializer.deserializeList(BACKENDENVIRONMENTLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BACKENDENVIRONMENTNAME_DESCRIPTOR.index -> builder.backendEnvironmentName = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
