// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.model



/**
 * The authentication settings for accessing provisioned data models in your Amplify project.
 */
public class BackendApiAppSyncAuthSettings private constructor(builder: Builder) {
    /**
     * The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data models.
     */
    public val cognitoUserPoolId: kotlin.String? = builder.cognitoUserPoolId
    /**
     * The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data models.
     */
    public val expirationTime: kotlin.Double = builder.expirationTime
    /**
     * The expiry time for the OpenID authentication mechanism.
     */
    public val openIdAuthTtl: kotlin.String? = builder.openIdAuthTtl
    /**
     * The clientID for openID, if openID was used as an authentication setting to access your data models.
     */
    public val openIdClientId: kotlin.String? = builder.openIdClientId
    /**
     * The expiry time for the OpenID authentication mechanism.
     */
    public val openIdIatTtl: kotlin.String? = builder.openIdIatTtl
    /**
     * The openID issuer URL, if openID was used as an authentication setting to access your data models.
     */
    public val openIdIssueUrl: kotlin.String? = builder.openIdIssueUrl
    /**
     * The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.
     */
    public val openIdProviderName: kotlin.String? = builder.openIdProviderName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifybackend.model.BackendApiAppSyncAuthSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackendApiAppSyncAuthSettings(")
        append("cognitoUserPoolId=$cognitoUserPoolId,")
        append("description=$description,")
        append("expirationTime=$expirationTime,")
        append("openIdAuthTtl=$openIdAuthTtl,")
        append("openIdClientId=$openIdClientId,")
        append("openIdIatTtl=$openIdIatTtl,")
        append("openIdIssueUrl=$openIdIssueUrl,")
        append("openIdProviderName=$openIdProviderName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cognitoUserPoolId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expirationTime.hashCode())
        result = 31 * result + (openIdAuthTtl?.hashCode() ?: 0)
        result = 31 * result + (openIdClientId?.hashCode() ?: 0)
        result = 31 * result + (openIdIatTtl?.hashCode() ?: 0)
        result = 31 * result + (openIdIssueUrl?.hashCode() ?: 0)
        result = 31 * result + (openIdProviderName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackendApiAppSyncAuthSettings

        if (cognitoUserPoolId != other.cognitoUserPoolId) return false
        if (description != other.description) return false
        if (expirationTime != other.expirationTime) return false
        if (openIdAuthTtl != other.openIdAuthTtl) return false
        if (openIdClientId != other.openIdClientId) return false
        if (openIdIatTtl != other.openIdIatTtl) return false
        if (openIdIssueUrl != other.openIdIssueUrl) return false
        if (openIdProviderName != other.openIdProviderName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifybackend.model.BackendApiAppSyncAuthSettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication setting to access your data models.
         */
        public var cognitoUserPoolId: kotlin.String? = null
        /**
         * The API key description for API_KEY, if it was used as an authentication mechanism to access your data models.
         */
        public var description: kotlin.String? = null
        /**
         * The API key expiration time for API_KEY, if it was used as an authentication mechanism to access your data models.
         */
        public var expirationTime: kotlin.Double = 0.0
        /**
         * The expiry time for the OpenID authentication mechanism.
         */
        public var openIdAuthTtl: kotlin.String? = null
        /**
         * The clientID for openID, if openID was used as an authentication setting to access your data models.
         */
        public var openIdClientId: kotlin.String? = null
        /**
         * The expiry time for the OpenID authentication mechanism.
         */
        public var openIdIatTtl: kotlin.String? = null
        /**
         * The openID issuer URL, if openID was used as an authentication setting to access your data models.
         */
        public var openIdIssueUrl: kotlin.String? = null
        /**
         * The OpenID provider name, if OpenID was used as an authentication mechanism to access your data models.
         */
        public var openIdProviderName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifybackend.model.BackendApiAppSyncAuthSettings) : this() {
            this.cognitoUserPoolId = x.cognitoUserPoolId
            this.description = x.description
            this.expirationTime = x.expirationTime
            this.openIdAuthTtl = x.openIdAuthTtl
            this.openIdClientId = x.openIdClientId
            this.openIdIatTtl = x.openIdIatTtl
            this.openIdIssueUrl = x.openIdIssueUrl
            this.openIdProviderName = x.openIdProviderName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifybackend.model.BackendApiAppSyncAuthSettings = BackendApiAppSyncAuthSettings(this)
    }
}
