// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.amplifybackend.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.amplifybackend.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.amplifybackend.model.*
import aws.sdk.kotlin.services.amplifybackend.model.CloneBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.GenerateBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListBackendJobsRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListS3BucketsRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveAllBackendsRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "AmplifyBackend"
public const val ServiceApiVersion: String = "2020-08-11"
public const val SdkVersion: String = "0.21.0-beta"

internal class DefaultAmplifyBackendClient(override val config: AmplifyBackendClient.Config) : AmplifyBackendClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * This operation clones an existing backend.
     */
    override suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse {
        val op = SdkHttpOperation.build<CloneBackendRequest, CloneBackendResponse> {
            serializer = CloneBackendOperationSerializer()
            deserializer = CloneBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CloneBackend"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CloneBackendRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CloneBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    override suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse {
        val op = SdkHttpOperation.build<CreateBackendRequest, CreateBackendResponse> {
            serializer = CreateBackendOperationSerializer()
            deserializer = CreateBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackend"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBackendRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new backend API resource.
     */
    override suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse {
        val op = SdkHttpOperation.build<CreateBackendApiRequest, CreateBackendApiResponse> {
            serializer = CreateBackendAPIOperationSerializer()
            deserializer = CreateBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackendAPI"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBackendApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new backend authentication resource.
     */
    override suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse {
        val op = SdkHttpOperation.build<CreateBackendAuthRequest, CreateBackendAuthResponse> {
            serializer = CreateBackendAuthOperationSerializer()
            deserializer = CreateBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackendAuth"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBackendAuthRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a config object for a backend.
     */
    override suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse {
        val op = SdkHttpOperation.build<CreateBackendConfigRequest, CreateBackendConfigResponse> {
            serializer = CreateBackendConfigOperationSerializer()
            deserializer = CreateBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackendConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBackendConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a backend storage resource.
     */
    override suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse {
        val op = SdkHttpOperation.build<CreateBackendStorageRequest, CreateBackendStorageResponse> {
            serializer = CreateBackendStorageOperationSerializer()
            deserializer = CreateBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackendStorage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBackendStorageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    override suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse {
        val op = SdkHttpOperation.build<CreateTokenRequest, CreateTokenResponse> {
            serializer = CreateTokenOperationSerializer()
            deserializer = CreateTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateToken"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateTokenRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes an existing environment from your Amplify project.
     */
    override suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse {
        val op = SdkHttpOperation.build<DeleteBackendRequest, DeleteBackendResponse> {
            serializer = DeleteBackendOperationSerializer()
            deserializer = DeleteBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackend"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBackendRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing backend API resource.
     */
    override suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse {
        val op = SdkHttpOperation.build<DeleteBackendApiRequest, DeleteBackendApiResponse> {
            serializer = DeleteBackendAPIOperationSerializer()
            deserializer = DeleteBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackendAPI"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBackendApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing backend authentication resource.
     */
    override suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse {
        val op = SdkHttpOperation.build<DeleteBackendAuthRequest, DeleteBackendAuthResponse> {
            serializer = DeleteBackendAuthOperationSerializer()
            deserializer = DeleteBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackendAuth"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBackendAuthRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified backend storage resource.
     */
    override suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse {
        val op = SdkHttpOperation.build<DeleteBackendStorageRequest, DeleteBackendStorageResponse> {
            serializer = DeleteBackendStorageOperationSerializer()
            deserializer = DeleteBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackendStorage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBackendStorageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    override suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse {
        val op = SdkHttpOperation.build<DeleteTokenRequest, DeleteTokenResponse> {
            serializer = DeleteTokenOperationSerializer()
            deserializer = DeleteTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteToken"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteTokenRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates a model schema for an existing backend API resource.
     */
    override suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse {
        val op = SdkHttpOperation.build<GenerateBackendApiModelsRequest, GenerateBackendApiModelsResponse> {
            serializer = GenerateBackendAPIModelsOperationSerializer()
            deserializer = GenerateBackendAPIModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GenerateBackendAPIModels"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GenerateBackendApiModelsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GenerateBackendAPIModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides project-level details for your Amplify UI project.
     */
    override suspend fun getBackend(input: GetBackendRequest): GetBackendResponse {
        val op = SdkHttpOperation.build<GetBackendRequest, GetBackendResponse> {
            serializer = GetBackendOperationSerializer()
            deserializer = GetBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackend"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the details for a backend API.
     */
    override suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse {
        val op = SdkHttpOperation.build<GetBackendApiRequest, GetBackendApiResponse> {
            serializer = GetBackendAPIOperationSerializer()
            deserializer = GetBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendAPI"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a model introspection schema for an existing backend API resource.
     */
    override suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse {
        val op = SdkHttpOperation.build<GetBackendApiModelsRequest, GetBackendApiModelsResponse> {
            serializer = GetBackendAPIModelsOperationSerializer()
            deserializer = GetBackendAPIModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendAPIModels"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendApiModelsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAPIModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a backend auth details.
     */
    override suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse {
        val op = SdkHttpOperation.build<GetBackendAuthRequest, GetBackendAuthResponse> {
            serializer = GetBackendAuthOperationSerializer()
            deserializer = GetBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendAuth"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendAuthRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific job.
     */
    override suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse {
        val op = SdkHttpOperation.build<GetBackendJobRequest, GetBackendJobResponse> {
            serializer = GetBackendJobOperationSerializer()
            deserializer = GetBackendJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets details for a backend storage resource.
     */
    override suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse {
        val op = SdkHttpOperation.build<GetBackendStorageRequest, GetBackendStorageResponse> {
            serializer = GetBackendStorageOperationSerializer()
            deserializer = GetBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendStorage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetBackendStorageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    override suspend fun getToken(input: GetTokenRequest): GetTokenResponse {
        val op = SdkHttpOperation.build<GetTokenRequest, GetTokenResponse> {
            serializer = GetTokenOperationSerializer()
            deserializer = GetTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetToken"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTokenRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Imports an existing backend authentication resource.
     */
    override suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse {
        val op = SdkHttpOperation.build<ImportBackendAuthRequest, ImportBackendAuthResponse> {
            serializer = ImportBackendAuthOperationSerializer()
            deserializer = ImportBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportBackendAuth"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ImportBackendAuthRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ImportBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Imports an existing backend storage resource.
     */
    override suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse {
        val op = SdkHttpOperation.build<ImportBackendStorageRequest, ImportBackendStorageResponse> {
            serializer = ImportBackendStorageOperationSerializer()
            deserializer = ImportBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportBackendStorage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ImportBackendStorageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ImportBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    override suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse {
        val op = SdkHttpOperation.build<ListBackendJobsRequest, ListBackendJobsResponse> {
            serializer = ListBackendJobsOperationSerializer()
            deserializer = ListBackendJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackendJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListBackendJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListBackendJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The list of S3 buckets in your account.
     */
    override suspend fun listS3Buckets(input: ListS3BucketsRequest): ListS3BucketsResponse {
        val op = SdkHttpOperation.build<ListS3BucketsRequest, ListS3BucketsResponse> {
            serializer = ListS3BucketsOperationSerializer()
            deserializer = ListS3BucketsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListS3Buckets"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListS3BucketsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListS3Buckets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes all backend environments from your Amplify project.
     */
    override suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse {
        val op = SdkHttpOperation.build<RemoveAllBackendsRequest, RemoveAllBackendsResponse> {
            serializer = RemoveAllBackendsOperationSerializer()
            deserializer = RemoveAllBackendsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveAllBackends"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveAllBackendsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveAllBackends-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    override suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse {
        val op = SdkHttpOperation.build<RemoveBackendConfigRequest, RemoveBackendConfigResponse> {
            serializer = RemoveBackendConfigOperationSerializer()
            deserializer = RemoveBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveBackendConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveBackendConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend API resource.
     */
    override suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse {
        val op = SdkHttpOperation.build<UpdateBackendApiRequest, UpdateBackendApiResponse> {
            serializer = UpdateBackendAPIOperationSerializer()
            deserializer = UpdateBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackendAPI"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBackendApiRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend authentication resource.
     */
    override suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse {
        val op = SdkHttpOperation.build<UpdateBackendAuthRequest, UpdateBackendAuthResponse> {
            serializer = UpdateBackendAuthOperationSerializer()
            deserializer = UpdateBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackendAuth"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBackendAuthRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    override suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse {
        val op = SdkHttpOperation.build<UpdateBackendConfigRequest, UpdateBackendConfigResponse> {
            serializer = UpdateBackendConfigOperationSerializer()
            deserializer = UpdateBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackendConfig"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBackendConfigRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a specific job.
     */
    override suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse {
        val op = SdkHttpOperation.build<UpdateBackendJobRequest, UpdateBackendJobResponse> {
            serializer = UpdateBackendJobOperationSerializer()
            deserializer = UpdateBackendJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackendJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBackendJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend storage resource.
     */
    override suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse {
        val op = SdkHttpOperation.build<UpdateBackendStorageRequest, UpdateBackendStorageResponse> {
            serializer = UpdateBackendStorageOperationSerializer()
            deserializer = UpdateBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBackendStorage"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateBackendStorageRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "amplifybackend"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "amplifybackend")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
