// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.amplifybackend.auth.AuthSchemeProviderAdapter
import aws.sdk.kotlin.services.amplifybackend.auth.IdentityProviderConfigAdapter
import aws.sdk.kotlin.services.amplifybackend.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.amplifybackend.model.*
import aws.sdk.kotlin.services.amplifybackend.transform.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "AmplifyBackend"
public const val ServiceApiVersion: String = "2020-08-11"
public const val SdkVersion: String = "0.23.0-beta"

internal class DefaultAmplifyBackendClient(override val config: AmplifyBackendClient.Config) : AmplifyBackendClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)
    private val identityProviderConfig = IdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(HttpAuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "amplifybackend")
        }
        toMap()
    }

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * This operation clones an existing backend.
     */
    override suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse {
        val op = SdkHttpOperation.build<CloneBackendRequest, CloneBackendResponse> {
            serializer = CloneBackendOperationSerializer()
            deserializer = CloneBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CloneBackend"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CloneBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    override suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse {
        val op = SdkHttpOperation.build<CreateBackendRequest, CreateBackendResponse> {
            serializer = CreateBackendOperationSerializer()
            deserializer = CreateBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBackend"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new backend API resource.
     */
    override suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse {
        val op = SdkHttpOperation.build<CreateBackendApiRequest, CreateBackendApiResponse> {
            serializer = CreateBackendAPIOperationSerializer()
            deserializer = CreateBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBackendAPI"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a new backend authentication resource.
     */
    override suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse {
        val op = SdkHttpOperation.build<CreateBackendAuthRequest, CreateBackendAuthResponse> {
            serializer = CreateBackendAuthOperationSerializer()
            deserializer = CreateBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBackendAuth"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a config object for a backend.
     */
    override suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse {
        val op = SdkHttpOperation.build<CreateBackendConfigRequest, CreateBackendConfigResponse> {
            serializer = CreateBackendConfigOperationSerializer()
            deserializer = CreateBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBackendConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a backend storage resource.
     */
    override suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse {
        val op = SdkHttpOperation.build<CreateBackendStorageRequest, CreateBackendStorageResponse> {
            serializer = CreateBackendStorageOperationSerializer()
            deserializer = CreateBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBackendStorage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    override suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse {
        val op = SdkHttpOperation.build<CreateTokenRequest, CreateTokenResponse> {
            serializer = CreateTokenOperationSerializer()
            deserializer = CreateTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateToken"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes an existing environment from your Amplify project.
     */
    override suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse {
        val op = SdkHttpOperation.build<DeleteBackendRequest, DeleteBackendResponse> {
            serializer = DeleteBackendOperationSerializer()
            deserializer = DeleteBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBackend"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing backend API resource.
     */
    override suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse {
        val op = SdkHttpOperation.build<DeleteBackendApiRequest, DeleteBackendApiResponse> {
            serializer = DeleteBackendAPIOperationSerializer()
            deserializer = DeleteBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBackendAPI"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an existing backend authentication resource.
     */
    override suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse {
        val op = SdkHttpOperation.build<DeleteBackendAuthRequest, DeleteBackendAuthResponse> {
            serializer = DeleteBackendAuthOperationSerializer()
            deserializer = DeleteBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBackendAuth"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified backend storage resource.
     */
    override suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse {
        val op = SdkHttpOperation.build<DeleteBackendStorageRequest, DeleteBackendStorageResponse> {
            serializer = DeleteBackendStorageOperationSerializer()
            deserializer = DeleteBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBackendStorage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    override suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse {
        val op = SdkHttpOperation.build<DeleteTokenRequest, DeleteTokenResponse> {
            serializer = DeleteTokenOperationSerializer()
            deserializer = DeleteTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteToken"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Generates a model schema for an existing backend API resource.
     */
    override suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse {
        val op = SdkHttpOperation.build<GenerateBackendApiModelsRequest, GenerateBackendApiModelsResponse> {
            serializer = GenerateBackendAPIModelsOperationSerializer()
            deserializer = GenerateBackendAPIModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GenerateBackendAPIModels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GenerateBackendAPIModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides project-level details for your Amplify UI project.
     */
    override suspend fun getBackend(input: GetBackendRequest): GetBackendResponse {
        val op = SdkHttpOperation.build<GetBackendRequest, GetBackendResponse> {
            serializer = GetBackendOperationSerializer()
            deserializer = GetBackendOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackend"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackend-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the details for a backend API.
     */
    override suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse {
        val op = SdkHttpOperation.build<GetBackendApiRequest, GetBackendApiResponse> {
            serializer = GetBackendAPIOperationSerializer()
            deserializer = GetBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackendAPI"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a model introspection schema for an existing backend API resource.
     */
    override suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse {
        val op = SdkHttpOperation.build<GetBackendApiModelsRequest, GetBackendApiModelsResponse> {
            serializer = GetBackendAPIModelsOperationSerializer()
            deserializer = GetBackendAPIModelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackendAPIModels"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAPIModels-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets a backend auth details.
     */
    override suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse {
        val op = SdkHttpOperation.build<GetBackendAuthRequest, GetBackendAuthResponse> {
            serializer = GetBackendAuthOperationSerializer()
            deserializer = GetBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackendAuth"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns information about a specific job.
     */
    override suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse {
        val op = SdkHttpOperation.build<GetBackendJobRequest, GetBackendJobResponse> {
            serializer = GetBackendJobOperationSerializer()
            deserializer = GetBackendJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackendJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets details for a backend storage resource.
     */
    override suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse {
        val op = SdkHttpOperation.build<GetBackendStorageRequest, GetBackendStorageResponse> {
            serializer = GetBackendStorageOperationSerializer()
            deserializer = GetBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetBackendStorage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    override suspend fun getToken(input: GetTokenRequest): GetTokenResponse {
        val op = SdkHttpOperation.build<GetTokenRequest, GetTokenResponse> {
            serializer = GetTokenOperationSerializer()
            deserializer = GetTokenOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetToken"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetToken-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Imports an existing backend authentication resource.
     */
    override suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse {
        val op = SdkHttpOperation.build<ImportBackendAuthRequest, ImportBackendAuthResponse> {
            serializer = ImportBackendAuthOperationSerializer()
            deserializer = ImportBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ImportBackendAuth"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ImportBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Imports an existing backend storage resource.
     */
    override suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse {
        val op = SdkHttpOperation.build<ImportBackendStorageRequest, ImportBackendStorageResponse> {
            serializer = ImportBackendStorageOperationSerializer()
            deserializer = ImportBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ImportBackendStorage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ImportBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    override suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse {
        val op = SdkHttpOperation.build<ListBackendJobsRequest, ListBackendJobsResponse> {
            serializer = ListBackendJobsOperationSerializer()
            deserializer = ListBackendJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListBackendJobs"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListBackendJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The list of S3 buckets in your account.
     */
    override suspend fun listS3Buckets(input: ListS3BucketsRequest): ListS3BucketsResponse {
        val op = SdkHttpOperation.build<ListS3BucketsRequest, ListS3BucketsResponse> {
            serializer = ListS3BucketsOperationSerializer()
            deserializer = ListS3BucketsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListS3Buckets"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListS3Buckets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes all backend environments from your Amplify project.
     */
    override suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse {
        val op = SdkHttpOperation.build<RemoveAllBackendsRequest, RemoveAllBackendsResponse> {
            serializer = RemoveAllBackendsOperationSerializer()
            deserializer = RemoveAllBackendsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "RemoveAllBackends"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveAllBackends-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    override suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse {
        val op = SdkHttpOperation.build<RemoveBackendConfigRequest, RemoveBackendConfigResponse> {
            serializer = RemoveBackendConfigOperationSerializer()
            deserializer = RemoveBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "RemoveBackendConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend API resource.
     */
    override suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse {
        val op = SdkHttpOperation.build<UpdateBackendApiRequest, UpdateBackendApiResponse> {
            serializer = UpdateBackendAPIOperationSerializer()
            deserializer = UpdateBackendAPIOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBackendAPI"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendAPI-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend authentication resource.
     */
    override suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse {
        val op = SdkHttpOperation.build<UpdateBackendAuthRequest, UpdateBackendAuthResponse> {
            serializer = UpdateBackendAuthOperationSerializer()
            deserializer = UpdateBackendAuthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBackendAuth"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendAuth-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    override suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse {
        val op = SdkHttpOperation.build<UpdateBackendConfigRequest, UpdateBackendConfigResponse> {
            serializer = UpdateBackendConfigOperationSerializer()
            deserializer = UpdateBackendConfigOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBackendConfig"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendConfig-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a specific job.
     */
    override suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse {
        val op = SdkHttpOperation.build<UpdateBackendJobRequest, UpdateBackendJobResponse> {
            serializer = UpdateBackendJobOperationSerializer()
            deserializer = UpdateBackendJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBackendJob"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an existing backend storage resource.
     */
    override suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse {
        val op = SdkHttpOperation.build<UpdateBackendStorageRequest, UpdateBackendStorageResponse> {
            serializer = UpdateBackendStorageOperationSerializer()
            deserializer = UpdateBackendStorageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateBackendStorage"
            }
            execution.auth = OperationAuthConfig(AuthSchemeProviderAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
        }
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateBackendStorage-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "amplifybackend")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
