// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.transform

import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageResourceConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBackendStorageOperationSerializer: HttpSerialize<CreateBackendStorageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateBackendStorageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "backend",
                "${input.appId}".encodeLabel(),
                "storage",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateBackendStorageOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateBackendStorageOperationBody(context: ExecutionContext, input: CreateBackendStorageRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKENDENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendEnvironmentName"))
    val RESOURCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("resourceConfig"))
    val RESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resourceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKENDENVIRONMENTNAME_DESCRIPTOR)
        field(RESOURCECONFIG_DESCRIPTOR)
        field(RESOURCENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backendEnvironmentName?.let { field(BACKENDENVIRONMENTNAME_DESCRIPTOR, it) }
        input.resourceConfig?.let { field(RESOURCECONFIG_DESCRIPTOR, it, ::serializeCreateBackendStorageResourceConfigDocument) }
        input.resourceName?.let { field(RESOURCENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
