// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.serde

import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportBackendAuthOperationSerializer: HttpSerialize<ImportBackendAuthRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportBackendAuthRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "backend",
                "${input.appId}".encodeLabel(),
                "auth",
                "${input.backendEnvironmentName}".encodeLabel(),
                "import",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeImportBackendAuthOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeImportBackendAuthOperationBody(context: ExecutionContext, input: ImportBackendAuthRequest): ByteArray {
    val serializer = JsonSerializer()
    val IDENTITYPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityPoolId"))
    val NATIVECLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nativeClientId"))
    val USERPOOLID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("userPoolId"))
    val WEBCLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("webClientId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDENTITYPOOLID_DESCRIPTOR)
        field(NATIVECLIENTID_DESCRIPTOR)
        field(USERPOOLID_DESCRIPTOR)
        field(WEBCLIENTID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.identityPoolId?.let { field(IDENTITYPOOLID_DESCRIPTOR, it) }
        input.nativeClientId?.let { field(NATIVECLIENTID_DESCRIPTOR, it) }
        input.userPoolId?.let { field(USERPOOLID_DESCRIPTOR, it) }
        input.webClientId?.let { field(WEBCLIENTID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
