// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.amplifybackend.auth.AmplifyBackendAuthSchemeProvider
import aws.sdk.kotlin.services.amplifybackend.auth.DefaultAmplifyBackendAuthSchemeProvider
import aws.sdk.kotlin.services.amplifybackend.endpoints.AmplifyBackendEndpointParameters
import aws.sdk.kotlin.services.amplifybackend.endpoints.AmplifyBackendEndpointProvider
import aws.sdk.kotlin.services.amplifybackend.endpoints.DefaultAmplifyBackendEndpointProvider
import aws.sdk.kotlin.services.amplifybackend.model.CloneBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CloneBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.CreateTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.CreateTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.DeleteTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.DeleteTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.GenerateBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GenerateBackendApiModelsResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiModelsRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiModelsResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendJobResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenRequest
import aws.sdk.kotlin.services.amplifybackend.model.GetTokenResponse
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.ImportBackendStorageResponse
import aws.sdk.kotlin.services.amplifybackend.model.ListBackendJobsRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListBackendJobsResponse
import aws.sdk.kotlin.services.amplifybackend.model.ListS3BucketsRequest
import aws.sdk.kotlin.services.amplifybackend.model.ListS3BucketsResponse
import aws.sdk.kotlin.services.amplifybackend.model.RemoveAllBackendsRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveAllBackendsResponse
import aws.sdk.kotlin.services.amplifybackend.model.RemoveBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.RemoveBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendApiRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendApiResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendJobRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendJobResponse
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendStorageRequest
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendStorageResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AmplifyBackend"
public const val SdkVersion: String = "1.0.62"
public const val ServiceApiVersion: String = "2020-08-11"

/**
 * AWS Amplify Admin API
 */
public interface AmplifyBackendClient : SdkClient {
    /**
     * AmplifyBackendClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AmplifyBackendClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AmplifyBackend",
                "AMPLIFYBACKEND",
                "amplifybackend",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AmplifyBackendClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AmplifyBackendClient = DefaultAmplifyBackendClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AmplifyBackendEndpointProvider = builder.endpointProvider ?: DefaultAmplifyBackendEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AmplifyBackendAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAmplifyBackendAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AmplifyBackend"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AmplifyBackendEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AmplifyBackendAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This operation clones an existing backend.
     */
    public suspend fun cloneBackend(input: CloneBackendRequest): CloneBackendResponse

    /**
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
     */
    public suspend fun createBackend(input: CreateBackendRequest): CreateBackendResponse

    /**
     * Creates a new backend API resource.
     */
    public suspend fun createBackendApi(input: CreateBackendApiRequest): CreateBackendApiResponse

    /**
     * Creates a new backend authentication resource.
     */
    public suspend fun createBackendAuth(input: CreateBackendAuthRequest): CreateBackendAuthResponse

    /**
     * Creates a config object for a backend.
     */
    public suspend fun createBackendConfig(input: CreateBackendConfigRequest): CreateBackendConfigResponse

    /**
     * Creates a backend storage resource.
     */
    public suspend fun createBackendStorage(input: CreateBackendStorageRequest): CreateBackendStorageResponse

    /**
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     */
    public suspend fun createToken(input: CreateTokenRequest): CreateTokenResponse

    /**
     * Removes an existing environment from your Amplify project.
     */
    public suspend fun deleteBackend(input: DeleteBackendRequest): DeleteBackendResponse

    /**
     * Deletes an existing backend API resource.
     */
    public suspend fun deleteBackendApi(input: DeleteBackendApiRequest): DeleteBackendApiResponse

    /**
     * Deletes an existing backend authentication resource.
     */
    public suspend fun deleteBackendAuth(input: DeleteBackendAuthRequest): DeleteBackendAuthResponse

    /**
     * Removes the specified backend storage resource.
     */
    public suspend fun deleteBackendStorage(input: DeleteBackendStorageRequest): DeleteBackendStorageResponse

    /**
     * Deletes the challenge token based on the given appId and sessionId.
     */
    public suspend fun deleteToken(input: DeleteTokenRequest): DeleteTokenResponse

    /**
     * Generates a model schema for an existing backend API resource.
     */
    public suspend fun generateBackendApiModels(input: GenerateBackendApiModelsRequest): GenerateBackendApiModelsResponse

    /**
     * Provides project-level details for your Amplify UI project.
     */
    public suspend fun getBackend(input: GetBackendRequest): GetBackendResponse

    /**
     * Gets the details for a backend API.
     */
    public suspend fun getBackendApi(input: GetBackendApiRequest): GetBackendApiResponse

    /**
     * Gets a model introspection schema for an existing backend API resource.
     */
    public suspend fun getBackendApiModels(input: GetBackendApiModelsRequest): GetBackendApiModelsResponse

    /**
     * Gets a backend auth details.
     */
    public suspend fun getBackendAuth(input: GetBackendAuthRequest): GetBackendAuthResponse

    /**
     * Returns information about a specific job.
     */
    public suspend fun getBackendJob(input: GetBackendJobRequest): GetBackendJobResponse

    /**
     * Gets details for a backend storage resource.
     */
    public suspend fun getBackendStorage(input: GetBackendStorageRequest): GetBackendStorageResponse

    /**
     * Gets the challenge token based on the given appId and sessionId.
     */
    public suspend fun getToken(input: GetTokenRequest): GetTokenResponse

    /**
     * Imports an existing backend authentication resource.
     */
    public suspend fun importBackendAuth(input: ImportBackendAuthRequest): ImportBackendAuthResponse

    /**
     * Imports an existing backend storage resource.
     */
    public suspend fun importBackendStorage(input: ImportBackendStorageRequest): ImportBackendStorageResponse

    /**
     * Lists the jobs for the backend of an Amplify app.
     */
    public suspend fun listBackendJobs(input: ListBackendJobsRequest): ListBackendJobsResponse

    /**
     * The list of S3 buckets in your account.
     */
    public suspend fun listS3Buckets(input: ListS3BucketsRequest = ListS3BucketsRequest { }): ListS3BucketsResponse

    /**
     * Removes all backend environments from your Amplify project.
     */
    public suspend fun removeAllBackends(input: RemoveAllBackendsRequest): RemoveAllBackendsResponse

    /**
     * Removes the AWS resources required to access the Amplify Admin UI.
     */
    public suspend fun removeBackendConfig(input: RemoveBackendConfigRequest): RemoveBackendConfigResponse

    /**
     * Updates an existing backend API resource.
     */
    public suspend fun updateBackendApi(input: UpdateBackendApiRequest): UpdateBackendApiResponse

    /**
     * Updates an existing backend authentication resource.
     */
    public suspend fun updateBackendAuth(input: UpdateBackendAuthRequest): UpdateBackendAuthResponse

    /**
     * Updates the AWS resources required to access the Amplify Admin UI.
     */
    public suspend fun updateBackendConfig(input: UpdateBackendConfigRequest): UpdateBackendConfigResponse

    /**
     * Updates a specific job.
     */
    public suspend fun updateBackendJob(input: UpdateBackendJobRequest): UpdateBackendJobResponse

    /**
     * Updates an existing backend storage resource.
     */
    public suspend fun updateBackendStorage(input: UpdateBackendStorageRequest): UpdateBackendStorageResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AmplifyBackendClient.withConfig(block: AmplifyBackendClient.Config.Builder.() -> Unit): AmplifyBackendClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAmplifyBackendClient(newConfig)
}

/**
 * This operation clones an existing backend.
 */
public suspend inline fun AmplifyBackendClient.cloneBackend(crossinline block: CloneBackendRequest.Builder.() -> Unit): CloneBackendResponse = cloneBackend(CloneBackendRequest.Builder().apply(block).build())

/**
 * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.
 */
public suspend inline fun AmplifyBackendClient.createBackend(crossinline block: CreateBackendRequest.Builder.() -> Unit): CreateBackendResponse = createBackend(CreateBackendRequest.Builder().apply(block).build())

/**
 * Creates a new backend API resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendApi(crossinline block: CreateBackendApiRequest.Builder.() -> Unit): CreateBackendApiResponse = createBackendApi(CreateBackendApiRequest.Builder().apply(block).build())

/**
 * Creates a new backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendAuth(crossinline block: CreateBackendAuthRequest.Builder.() -> Unit): CreateBackendAuthResponse = createBackendAuth(CreateBackendAuthRequest.Builder().apply(block).build())

/**
 * Creates a config object for a backend.
 */
public suspend inline fun AmplifyBackendClient.createBackendConfig(crossinline block: CreateBackendConfigRequest.Builder.() -> Unit): CreateBackendConfigResponse = createBackendConfig(CreateBackendConfigRequest.Builder().apply(block).build())

/**
 * Creates a backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.createBackendStorage(crossinline block: CreateBackendStorageRequest.Builder.() -> Unit): CreateBackendStorageResponse = createBackendStorage(CreateBackendStorageRequest.Builder().apply(block).build())

/**
 * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.createToken(crossinline block: CreateTokenRequest.Builder.() -> Unit): CreateTokenResponse = createToken(CreateTokenRequest.Builder().apply(block).build())

/**
 * Removes an existing environment from your Amplify project.
 */
public suspend inline fun AmplifyBackendClient.deleteBackend(crossinline block: DeleteBackendRequest.Builder.() -> Unit): DeleteBackendResponse = deleteBackend(DeleteBackendRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendApi(crossinline block: DeleteBackendApiRequest.Builder.() -> Unit): DeleteBackendApiResponse = deleteBackendApi(DeleteBackendApiRequest.Builder().apply(block).build())

/**
 * Deletes an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendAuth(crossinline block: DeleteBackendAuthRequest.Builder.() -> Unit): DeleteBackendAuthResponse = deleteBackendAuth(DeleteBackendAuthRequest.Builder().apply(block).build())

/**
 * Removes the specified backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.deleteBackendStorage(crossinline block: DeleteBackendStorageRequest.Builder.() -> Unit): DeleteBackendStorageResponse = deleteBackendStorage(DeleteBackendStorageRequest.Builder().apply(block).build())

/**
 * Deletes the challenge token based on the given appId and sessionId.
 */
public suspend inline fun AmplifyBackendClient.deleteToken(crossinline block: DeleteTokenRequest.Builder.() -> Unit): DeleteTokenResponse = deleteToken(DeleteTokenRequest.Builder().apply(block).build())

/**
 * Generates a model schema for an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.generateBackendApiModels(crossinline block: GenerateBackendApiModelsRequest.Builder.() -> Unit): GenerateBackendApiModelsResponse = generateBackendApiModels(GenerateBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Provides project-level details for your Amplify UI project.
 */
public suspend inline fun AmplifyBackendClient.getBackend(crossinline block: GetBackendRequest.Builder.() -> Unit): GetBackendResponse = getBackend(GetBackendRequest.Builder().apply(block).build())

/**
 * Gets the details for a backend API.
 */
public suspend inline fun AmplifyBackendClient.getBackendApi(crossinline block: GetBackendApiRequest.Builder.() -> Unit): GetBackendApiResponse = getBackendApi(GetBackendApiRequest.Builder().apply(block).build())

/**
 * Gets a model introspection schema for an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.getBackendApiModels(crossinline block: GetBackendApiModelsRequest.Builder.() -> Unit): GetBackendApiModelsResponse = getBackendApiModels(GetBackendApiModelsRequest.Builder().apply(block).build())

/**
 * Gets a backend auth details.
 */
public suspend inline fun AmplifyBackendClient.getBackendAuth(crossinline block: GetBackendAuthRequest.Builder.() -> Unit): GetBackendAuthResponse = getBackendAuth(GetBackendAuthRequest.Builder().apply(block).build())

/**
 * Returns information about a specific job.
 */
public suspend inline fun AmplifyBackendClient.getBackendJob(crossinline block: GetBackendJobRequest.Builder.() -> Unit): GetBackendJobResponse = getBackendJob(GetBackendJobRequest.Builder().apply(block).build())

/**
 * Gets details for a backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.getBackendStorage(crossinline block: GetBackendStorageRequest.Builder.() -> Unit): GetBackendStorageResponse = getBackendStorage(GetBackendStorageRequest.Builder().apply(block).build())

/**
 * Gets the challenge token based on the given appId and sessionId.
 */
public suspend inline fun AmplifyBackendClient.getToken(crossinline block: GetTokenRequest.Builder.() -> Unit): GetTokenResponse = getToken(GetTokenRequest.Builder().apply(block).build())

/**
 * Imports an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.importBackendAuth(crossinline block: ImportBackendAuthRequest.Builder.() -> Unit): ImportBackendAuthResponse = importBackendAuth(ImportBackendAuthRequest.Builder().apply(block).build())

/**
 * Imports an existing backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.importBackendStorage(crossinline block: ImportBackendStorageRequest.Builder.() -> Unit): ImportBackendStorageResponse = importBackendStorage(ImportBackendStorageRequest.Builder().apply(block).build())

/**
 * Lists the jobs for the backend of an Amplify app.
 */
public suspend inline fun AmplifyBackendClient.listBackendJobs(crossinline block: ListBackendJobsRequest.Builder.() -> Unit): ListBackendJobsResponse = listBackendJobs(ListBackendJobsRequest.Builder().apply(block).build())

/**
 * The list of S3 buckets in your account.
 */
public suspend inline fun AmplifyBackendClient.listS3Buckets(crossinline block: ListS3BucketsRequest.Builder.() -> Unit): ListS3BucketsResponse = listS3Buckets(ListS3BucketsRequest.Builder().apply(block).build())

/**
 * Removes all backend environments from your Amplify project.
 */
public suspend inline fun AmplifyBackendClient.removeAllBackends(crossinline block: RemoveAllBackendsRequest.Builder.() -> Unit): RemoveAllBackendsResponse = removeAllBackends(RemoveAllBackendsRequest.Builder().apply(block).build())

/**
 * Removes the AWS resources required to access the Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.removeBackendConfig(crossinline block: RemoveBackendConfigRequest.Builder.() -> Unit): RemoveBackendConfigResponse = removeBackendConfig(RemoveBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates an existing backend API resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendApi(crossinline block: UpdateBackendApiRequest.Builder.() -> Unit): UpdateBackendApiResponse = updateBackendApi(UpdateBackendApiRequest.Builder().apply(block).build())

/**
 * Updates an existing backend authentication resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendAuth(crossinline block: UpdateBackendAuthRequest.Builder.() -> Unit): UpdateBackendAuthResponse = updateBackendAuth(UpdateBackendAuthRequest.Builder().apply(block).build())

/**
 * Updates the AWS resources required to access the Amplify Admin UI.
 */
public suspend inline fun AmplifyBackendClient.updateBackendConfig(crossinline block: UpdateBackendConfigRequest.Builder.() -> Unit): UpdateBackendConfigResponse = updateBackendConfig(UpdateBackendConfigRequest.Builder().apply(block).build())

/**
 * Updates a specific job.
 */
public suspend inline fun AmplifyBackendClient.updateBackendJob(crossinline block: UpdateBackendJobRequest.Builder.() -> Unit): UpdateBackendJobResponse = updateBackendJob(UpdateBackendJobRequest.Builder().apply(block).build())

/**
 * Updates an existing backend storage resource.
 */
public suspend inline fun AmplifyBackendClient.updateBackendStorage(crossinline block: UpdateBackendStorageRequest.Builder.() -> Unit): UpdateBackendStorageResponse = updateBackendStorage(UpdateBackendStorageRequest.Builder().apply(block).build())
