// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The OAuth configurations for authenticating users into your Amplify app.
 */
public class UpdateBackendAuthOAuthConfig private constructor(builder: Builder) {
    /**
     * The Amazon Cognito domain prefix used to create a hosted UI for authentication.
     */
    public val domainPrefix: kotlin.String? = builder.domainPrefix
    /**
     * The OAuth grant type to allow app users to authenticate from your Amplify app.
     */
    public val oAuthGrantType: aws.sdk.kotlin.services.amplifybackend.model.OAuthGrantType? = builder.oAuthGrantType
    /**
     * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
     */
    public val oAuthScopes: List<OAuthScopesElement>? = builder.oAuthScopes
    /**
     * Redirect URLs that OAuth uses when a user signs in to an Amplify app.
     */
    public val redirectSignInUris: List<String>? = builder.redirectSignInUris
    /**
     * Redirect URLs that OAuth uses when a user signs out of an Amplify app.
     */
    public val redirectSignOutUris: List<String>? = builder.redirectSignOutUris
    /**
     * Describes third-party social federation configurations for allowing your users to sign in with OAuth.
     */
    public val socialProviderSettings: aws.sdk.kotlin.services.amplifybackend.model.SocialProviderSettings? = builder.socialProviderSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthOAuthConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateBackendAuthOAuthConfig(")
        append("domainPrefix=$domainPrefix,")
        append("oAuthGrantType=$oAuthGrantType,")
        append("oAuthScopes=$oAuthScopes,")
        append("redirectSignInUris=$redirectSignInUris,")
        append("redirectSignOutUris=$redirectSignOutUris,")
        append("socialProviderSettings=$socialProviderSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainPrefix?.hashCode() ?: 0
        result = 31 * result + (oAuthGrantType?.hashCode() ?: 0)
        result = 31 * result + (oAuthScopes?.hashCode() ?: 0)
        result = 31 * result + (redirectSignInUris?.hashCode() ?: 0)
        result = 31 * result + (redirectSignOutUris?.hashCode() ?: 0)
        result = 31 * result + (socialProviderSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateBackendAuthOAuthConfig

        if (domainPrefix != other.domainPrefix) return false
        if (oAuthGrantType != other.oAuthGrantType) return false
        if (oAuthScopes != other.oAuthScopes) return false
        if (redirectSignInUris != other.redirectSignInUris) return false
        if (redirectSignOutUris != other.redirectSignOutUris) return false
        if (socialProviderSettings != other.socialProviderSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthOAuthConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Cognito domain prefix used to create a hosted UI for authentication.
         */
        public var domainPrefix: kotlin.String? = null
        /**
         * The OAuth grant type to allow app users to authenticate from your Amplify app.
         */
        public var oAuthGrantType: aws.sdk.kotlin.services.amplifybackend.model.OAuthGrantType? = null
        /**
         * The list of OAuth-related flows that can allow users to authenticate from your Amplify app.
         */
        public var oAuthScopes: List<OAuthScopesElement>? = null
        /**
         * Redirect URLs that OAuth uses when a user signs in to an Amplify app.
         */
        public var redirectSignInUris: List<String>? = null
        /**
         * Redirect URLs that OAuth uses when a user signs out of an Amplify app.
         */
        public var redirectSignOutUris: List<String>? = null
        /**
         * Describes third-party social federation configurations for allowing your users to sign in with OAuth.
         */
        public var socialProviderSettings: aws.sdk.kotlin.services.amplifybackend.model.SocialProviderSettings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthOAuthConfig) : this() {
            this.domainPrefix = x.domainPrefix
            this.oAuthGrantType = x.oAuthGrantType
            this.oAuthScopes = x.oAuthScopes
            this.redirectSignInUris = x.redirectSignInUris
            this.redirectSignOutUris = x.redirectSignOutUris
            this.socialProviderSettings = x.socialProviderSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendAuthOAuthConfig = UpdateBackendAuthOAuthConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplifybackend.model.SocialProviderSettings] inside the given [block]
         */
        public fun socialProviderSettings(block: aws.sdk.kotlin.services.amplifybackend.model.SocialProviderSettings.Builder.() -> kotlin.Unit) {
            this.socialProviderSettings = aws.sdk.kotlin.services.amplifybackend.model.SocialProviderSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
