// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.*
import aws.sdk.kotlin.services.apigatewaymanagementapi.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "ApiGatewayManagementApi"
const val ServiceApiVersion: String = "2018-11-29"
const val SdkVersion: String = "0.10.0-beta"

internal class DefaultApiGatewayManagementClient(override val config: ApiGatewayManagementClient.Config) : ApiGatewayManagementClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Delete the connection with the provided id.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get information about the connection with the provided id.
     */
    override suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse {
        val op = SdkHttpOperation.build<GetConnectionRequest, GetConnectionResponse> {
            serializer = GetConnectionOperationSerializer()
            deserializer = GetConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends the provided data to the specified connection.
     */
    override suspend fun postToConnection(input: PostToConnectionRequest): PostToConnectionResponse {
        val op = SdkHttpOperation.build<PostToConnectionRequest, PostToConnectionResponse> {
            serializer = PostToConnectionOperationSerializer()
            deserializer = PostToConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostToConnection"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "execute-api"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
