// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.ApiGatewayManagementException
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.DeleteConnectionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteConnectionOperationDeserializer: HttpDeserialize<DeleteConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteConnectionResponse {
        if (!response.status.isSuccess()) {
            throwDeleteConnectionError(context, response)
        }
        val builder = DeleteConnectionResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayManagementException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "GoneException" -> GoneExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        else -> throw ApiGatewayManagementException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
