// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.apigatewaymanagementapi.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.apigatewaymanagementapi.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.*
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.GetConnectionRequest
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.PostToConnectionRequest
import aws.sdk.kotlin.services.apigatewaymanagementapi.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "ApiGatewayManagementApi"
public const val ServiceApiVersion: String = "2018-11-29"
public const val SdkVersion: String = "0.20.3-beta"

internal class DefaultApiGatewayManagementClient(override val config: ApiGatewayManagementClient.Config) : ApiGatewayManagementClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Delete the connection with the provided id.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "execute-api"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get information about the connection with the provided id.
     */
    override suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse {
        val op = SdkHttpOperation.build<GetConnectionRequest, GetConnectionResponse> {
            serializer = GetConnectionOperationSerializer()
            deserializer = GetConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "execute-api"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sends the provided data to the specified connection.
     */
    override suspend fun postToConnection(input: PostToConnectionRequest): PostToConnectionResponse {
        val op = SdkHttpOperation.build<PostToConnectionRequest, PostToConnectionResponse> {
            serializer = PostToConnectionOperationSerializer()
            deserializer = PostToConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostToConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<PostToConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "execute-api"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("PostToConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "execute-api")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
