// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.*
import aws.sdk.kotlin.services.apigatewaymanagementapi.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "ApiGatewayManagementApi"
const val ServiceApiVersion: String = "2018-11-29"
const val SdkVersion: String = "0.5.0-alpha"

internal class DefaultApiGatewayManagementClient(override val config: ApiGatewayManagementClient.Config) : ApiGatewayManagementClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Delete the connection with the provided id.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteConnection"
            }
        }
        registerDeleteConnectionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Get information about the connection with the provided id.
     */
    override suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse {
        val op = SdkHttpOperation.build<GetConnectionRequest, GetConnectionResponse> {
            serializer = GetConnectionOperationSerializer()
            deserializer = GetConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetConnection"
            }
        }
        registerGetConnectionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends the provided data to the specified connection.
     */
    override suspend fun postToConnection(input: PostToConnectionRequest): PostToConnectionResponse {
        val op = SdkHttpOperation.build<PostToConnectionRequest, PostToConnectionResponse> {
            serializer = PostToConnectionOperationSerializer()
            deserializer = PostToConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PostToConnection"
            }
        }
        registerPostToConnectionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
