// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewaymanagementapi.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.ApiGatewayManagementException
import aws.sdk.kotlin.services.apigatewaymanagementapi.model.GetConnectionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetConnectionOperationDeserializer: HttpDeserialize<GetConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetConnectionResponse {
        if (!response.status.isSuccess()) {
            throwGetConnectionError(context, response)
        }
        val builder = GetConnectionResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetConnectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetConnectionOperationBody(builder: GetConnectionResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("connectedAt"))
    val IDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("identity"))
    val LASTACTIVEAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastActiveAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTEDAT_DESCRIPTOR)
        field(IDENTITY_DESCRIPTOR)
        field(LASTACTIVEAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTEDAT_DESCRIPTOR.index -> builder.connectedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                IDENTITY_DESCRIPTOR.index -> builder.identity = deserializeIdentityDocument(deserializer)
                LASTACTIVEAT_DESCRIPTOR.index -> builder.lastActiveAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "GoneException" -> GoneExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        else -> throw ApiGatewayManagementException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
