// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.apigatewayv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.apigatewayv2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon API Gateway V2
 */
interface ApiGatewayV2Client : SdkClient {

    override val serviceName: String
        get() = "ApiGatewayV2"
    /**
     * ApiGatewayV2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ApiGatewayV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultApiGatewayV2Client(config)
        }

        operator fun invoke(config: Config): ApiGatewayV2Client = DefaultApiGatewayV2Client(config)

        /**
         * Construct a [ApiGatewayV2Client] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ApiGatewayV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultApiGatewayV2Client(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Api resource.
     */
    suspend fun createApi(input: CreateApiRequest): CreateApiResponse

    /**
     * Creates an Api resource.
     */
    suspend fun createApi(block: CreateApiRequest.Builder.() -> Unit) = createApi(CreateApiRequest.Builder().apply(block).build())

    /**
     * Creates an API mapping.
     */
    suspend fun createApiMapping(input: CreateApiMappingRequest): CreateApiMappingResponse

    /**
     * Creates an API mapping.
     */
    suspend fun createApiMapping(block: CreateApiMappingRequest.Builder.() -> Unit) = createApiMapping(CreateApiMappingRequest.Builder().apply(block).build())

    /**
     * Creates an Authorizer for an API.
     */
    suspend fun createAuthorizer(input: CreateAuthorizerRequest): CreateAuthorizerResponse

    /**
     * Creates an Authorizer for an API.
     */
    suspend fun createAuthorizer(block: CreateAuthorizerRequest.Builder.() -> Unit) = createAuthorizer(CreateAuthorizerRequest.Builder().apply(block).build())

    /**
     * Creates a Deployment for an API.
     */
    suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a Deployment for an API.
     */
    suspend fun createDeployment(block: CreateDeploymentRequest.Builder.() -> Unit) = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

    /**
     * Creates a domain name.
     */
    suspend fun createDomainName(input: CreateDomainNameRequest): CreateDomainNameResponse

    /**
     * Creates a domain name.
     */
    suspend fun createDomainName(block: CreateDomainNameRequest.Builder.() -> Unit) = createDomainName(CreateDomainNameRequest.Builder().apply(block).build())

    /**
     * Creates an Integration.
     */
    suspend fun createIntegration(input: CreateIntegrationRequest): CreateIntegrationResponse

    /**
     * Creates an Integration.
     */
    suspend fun createIntegration(block: CreateIntegrationRequest.Builder.() -> Unit) = createIntegration(CreateIntegrationRequest.Builder().apply(block).build())

    /**
     * Creates an IntegrationResponses.
     */
    suspend fun createIntegrationResponse(input: CreateIntegrationResponseRequest): CreateIntegrationResponseResponse

    /**
     * Creates an IntegrationResponses.
     */
    suspend fun createIntegrationResponse(block: CreateIntegrationResponseRequest.Builder.() -> Unit) = createIntegrationResponse(CreateIntegrationResponseRequest.Builder().apply(block).build())

    /**
     * Creates a Model for an API.
     */
    suspend fun createModel(input: CreateModelRequest): CreateModelResponse

    /**
     * Creates a Model for an API.
     */
    suspend fun createModel(block: CreateModelRequest.Builder.() -> Unit) = createModel(CreateModelRequest.Builder().apply(block).build())

    /**
     * Creates a Route for an API.
     */
    suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates a Route for an API.
     */
    suspend fun createRoute(block: CreateRouteRequest.Builder.() -> Unit) = createRoute(CreateRouteRequest.Builder().apply(block).build())

    /**
     * Creates a RouteResponse for a Route.
     */
    suspend fun createRouteResponse(input: CreateRouteResponseRequest): CreateRouteResponseResponse

    /**
     * Creates a RouteResponse for a Route.
     */
    suspend fun createRouteResponse(block: CreateRouteResponseRequest.Builder.() -> Unit) = createRouteResponse(CreateRouteResponseRequest.Builder().apply(block).build())

    /**
     * Creates a Stage for an API.
     */
    suspend fun createStage(input: CreateStageRequest): CreateStageResponse

    /**
     * Creates a Stage for an API.
     */
    suspend fun createStage(block: CreateStageRequest.Builder.() -> Unit) = createStage(CreateStageRequest.Builder().apply(block).build())

    /**
     * Creates a VPC link.
     */
    suspend fun createVpcLink(input: CreateVpcLinkRequest): CreateVpcLinkResponse

    /**
     * Creates a VPC link.
     */
    suspend fun createVpcLink(block: CreateVpcLinkRequest.Builder.() -> Unit) = createVpcLink(CreateVpcLinkRequest.Builder().apply(block).build())

    /**
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     */
    suspend fun deleteAccessLogSettings(input: DeleteAccessLogSettingsRequest): DeleteAccessLogSettingsResponse

    /**
     * Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.
     */
    suspend fun deleteAccessLogSettings(block: DeleteAccessLogSettingsRequest.Builder.() -> Unit) = deleteAccessLogSettings(DeleteAccessLogSettingsRequest.Builder().apply(block).build())

    /**
     * Deletes an Api resource.
     */
    suspend fun deleteApi(input: DeleteApiRequest): DeleteApiResponse

    /**
     * Deletes an Api resource.
     */
    suspend fun deleteApi(block: DeleteApiRequest.Builder.() -> Unit) = deleteApi(DeleteApiRequest.Builder().apply(block).build())

    /**
     * Deletes an API mapping.
     */
    suspend fun deleteApiMapping(input: DeleteApiMappingRequest): DeleteApiMappingResponse

    /**
     * Deletes an API mapping.
     */
    suspend fun deleteApiMapping(block: DeleteApiMappingRequest.Builder.() -> Unit) = deleteApiMapping(DeleteApiMappingRequest.Builder().apply(block).build())

    /**
     * Deletes an Authorizer.
     */
    suspend fun deleteAuthorizer(input: DeleteAuthorizerRequest): DeleteAuthorizerResponse

    /**
     * Deletes an Authorizer.
     */
    suspend fun deleteAuthorizer(block: DeleteAuthorizerRequest.Builder.() -> Unit) = deleteAuthorizer(DeleteAuthorizerRequest.Builder().apply(block).build())

    /**
     * Deletes a CORS configuration.
     */
    suspend fun deleteCorsConfiguration(input: DeleteCorsConfigurationRequest): DeleteCorsConfigurationResponse

    /**
     * Deletes a CORS configuration.
     */
    suspend fun deleteCorsConfiguration(block: DeleteCorsConfigurationRequest.Builder.() -> Unit) = deleteCorsConfiguration(DeleteCorsConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes a Deployment.
     */
    suspend fun deleteDeployment(input: DeleteDeploymentRequest): DeleteDeploymentResponse

    /**
     * Deletes a Deployment.
     */
    suspend fun deleteDeployment(block: DeleteDeploymentRequest.Builder.() -> Unit) = deleteDeployment(DeleteDeploymentRequest.Builder().apply(block).build())

    /**
     * Deletes a domain name.
     */
    suspend fun deleteDomainName(input: DeleteDomainNameRequest): DeleteDomainNameResponse

    /**
     * Deletes a domain name.
     */
    suspend fun deleteDomainName(block: DeleteDomainNameRequest.Builder.() -> Unit) = deleteDomainName(DeleteDomainNameRequest.Builder().apply(block).build())

    /**
     * Deletes an Integration.
     */
    suspend fun deleteIntegration(input: DeleteIntegrationRequest): DeleteIntegrationResponse

    /**
     * Deletes an Integration.
     */
    suspend fun deleteIntegration(block: DeleteIntegrationRequest.Builder.() -> Unit) = deleteIntegration(DeleteIntegrationRequest.Builder().apply(block).build())

    /**
     * Deletes an IntegrationResponses.
     */
    suspend fun deleteIntegrationResponse(input: DeleteIntegrationResponseRequest): DeleteIntegrationResponseResponse

    /**
     * Deletes an IntegrationResponses.
     */
    suspend fun deleteIntegrationResponse(block: DeleteIntegrationResponseRequest.Builder.() -> Unit) = deleteIntegrationResponse(DeleteIntegrationResponseRequest.Builder().apply(block).build())

    /**
     * Deletes a Model.
     */
    suspend fun deleteModel(input: DeleteModelRequest): DeleteModelResponse

    /**
     * Deletes a Model.
     */
    suspend fun deleteModel(block: DeleteModelRequest.Builder.() -> Unit) = deleteModel(DeleteModelRequest.Builder().apply(block).build())

    /**
     * Deletes a Route.
     */
    suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes a Route.
     */
    suspend fun deleteRoute(block: DeleteRouteRequest.Builder.() -> Unit) = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

    /**
     * Deletes a route request parameter.
     */
    suspend fun deleteRouteRequestParameter(input: DeleteRouteRequestParameterRequest): DeleteRouteRequestParameterResponse

    /**
     * Deletes a route request parameter.
     */
    suspend fun deleteRouteRequestParameter(block: DeleteRouteRequestParameterRequest.Builder.() -> Unit) = deleteRouteRequestParameter(DeleteRouteRequestParameterRequest.Builder().apply(block).build())

    /**
     * Deletes a RouteResponse.
     */
    suspend fun deleteRouteResponse(input: DeleteRouteResponseRequest): DeleteRouteResponseResponse

    /**
     * Deletes a RouteResponse.
     */
    suspend fun deleteRouteResponse(block: DeleteRouteResponseRequest.Builder.() -> Unit) = deleteRouteResponse(DeleteRouteResponseRequest.Builder().apply(block).build())

    /**
     * Deletes the RouteSettings for a stage.
     */
    suspend fun deleteRouteSettings(input: DeleteRouteSettingsRequest): DeleteRouteSettingsResponse

    /**
     * Deletes the RouteSettings for a stage.
     */
    suspend fun deleteRouteSettings(block: DeleteRouteSettingsRequest.Builder.() -> Unit) = deleteRouteSettings(DeleteRouteSettingsRequest.Builder().apply(block).build())

    /**
     * Deletes a Stage.
     */
    suspend fun deleteStage(input: DeleteStageRequest): DeleteStageResponse

    /**
     * Deletes a Stage.
     */
    suspend fun deleteStage(block: DeleteStageRequest.Builder.() -> Unit) = deleteStage(DeleteStageRequest.Builder().apply(block).build())

    /**
     * Deletes a VPC link.
     */
    suspend fun deleteVpcLink(input: DeleteVpcLinkRequest): DeleteVpcLinkResponse

    /**
     * Deletes a VPC link.
     */
    suspend fun deleteVpcLink(block: DeleteVpcLinkRequest.Builder.() -> Unit) = deleteVpcLink(DeleteVpcLinkRequest.Builder().apply(block).build())

    suspend fun exportApi(input: ExportApiRequest): ExportApiResponse

    suspend fun exportApi(block: ExportApiRequest.Builder.() -> Unit) = exportApi(ExportApiRequest.Builder().apply(block).build())

    /**
     * Gets an Api resource.
     */
    suspend fun getApi(input: GetApiRequest): GetApiResponse

    /**
     * Gets an Api resource.
     */
    suspend fun getApi(block: GetApiRequest.Builder.() -> Unit) = getApi(GetApiRequest.Builder().apply(block).build())

    /**
     * Gets an API mapping.
     */
    suspend fun getApiMapping(input: GetApiMappingRequest): GetApiMappingResponse

    /**
     * Gets an API mapping.
     */
    suspend fun getApiMapping(block: GetApiMappingRequest.Builder.() -> Unit) = getApiMapping(GetApiMappingRequest.Builder().apply(block).build())

    /**
     * Gets API mappings.
     */
    suspend fun getApiMappings(input: GetApiMappingsRequest): GetApiMappingsResponse

    /**
     * Gets API mappings.
     */
    suspend fun getApiMappings(block: GetApiMappingsRequest.Builder.() -> Unit) = getApiMappings(GetApiMappingsRequest.Builder().apply(block).build())

    /**
     * Gets a collection of Api resources.
     */
    suspend fun getApis(input: GetApisRequest = GetApisRequest {}): GetApisResponse

    /**
     * Gets a collection of Api resources.
     */
    suspend fun getApis(block: GetApisRequest.Builder.() -> Unit) = getApis(GetApisRequest.Builder().apply(block).build())

    /**
     * Gets an Authorizer.
     */
    suspend fun getAuthorizer(input: GetAuthorizerRequest): GetAuthorizerResponse

    /**
     * Gets an Authorizer.
     */
    suspend fun getAuthorizer(block: GetAuthorizerRequest.Builder.() -> Unit) = getAuthorizer(GetAuthorizerRequest.Builder().apply(block).build())

    /**
     * Gets the Authorizers for an API.
     */
    suspend fun getAuthorizers(input: GetAuthorizersRequest): GetAuthorizersResponse

    /**
     * Gets the Authorizers for an API.
     */
    suspend fun getAuthorizers(block: GetAuthorizersRequest.Builder.() -> Unit) = getAuthorizers(GetAuthorizersRequest.Builder().apply(block).build())

    /**
     * Gets a Deployment.
     */
    suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets a Deployment.
     */
    suspend fun getDeployment(block: GetDeploymentRequest.Builder.() -> Unit) = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

    /**
     * Gets the Deployments for an API.
     */
    suspend fun getDeployments(input: GetDeploymentsRequest): GetDeploymentsResponse

    /**
     * Gets the Deployments for an API.
     */
    suspend fun getDeployments(block: GetDeploymentsRequest.Builder.() -> Unit) = getDeployments(GetDeploymentsRequest.Builder().apply(block).build())

    /**
     * Gets a domain name.
     */
    suspend fun getDomainName(input: GetDomainNameRequest): GetDomainNameResponse

    /**
     * Gets a domain name.
     */
    suspend fun getDomainName(block: GetDomainNameRequest.Builder.() -> Unit) = getDomainName(GetDomainNameRequest.Builder().apply(block).build())

    /**
     * Gets the domain names for an AWS account.
     */
    suspend fun getDomainNames(input: GetDomainNamesRequest = GetDomainNamesRequest {}): GetDomainNamesResponse

    /**
     * Gets the domain names for an AWS account.
     */
    suspend fun getDomainNames(block: GetDomainNamesRequest.Builder.() -> Unit) = getDomainNames(GetDomainNamesRequest.Builder().apply(block).build())

    /**
     * Gets an Integration.
     */
    suspend fun getIntegration(input: GetIntegrationRequest): GetIntegrationResponse

    /**
     * Gets an Integration.
     */
    suspend fun getIntegration(block: GetIntegrationRequest.Builder.() -> Unit) = getIntegration(GetIntegrationRequest.Builder().apply(block).build())

    /**
     * Gets an IntegrationResponses.
     */
    suspend fun getIntegrationResponse(input: GetIntegrationResponseRequest): GetIntegrationResponseResponse

    /**
     * Gets an IntegrationResponses.
     */
    suspend fun getIntegrationResponse(block: GetIntegrationResponseRequest.Builder.() -> Unit) = getIntegrationResponse(GetIntegrationResponseRequest.Builder().apply(block).build())

    /**
     * Gets the IntegrationResponses for an Integration.
     */
    suspend fun getIntegrationResponses(input: GetIntegrationResponsesRequest): GetIntegrationResponsesResponse

    /**
     * Gets the IntegrationResponses for an Integration.
     */
    suspend fun getIntegrationResponses(block: GetIntegrationResponsesRequest.Builder.() -> Unit) = getIntegrationResponses(GetIntegrationResponsesRequest.Builder().apply(block).build())

    /**
     * Gets the Integrations for an API.
     */
    suspend fun getIntegrations(input: GetIntegrationsRequest): GetIntegrationsResponse

    /**
     * Gets the Integrations for an API.
     */
    suspend fun getIntegrations(block: GetIntegrationsRequest.Builder.() -> Unit) = getIntegrations(GetIntegrationsRequest.Builder().apply(block).build())

    /**
     * Gets a Model.
     */
    suspend fun getModel(input: GetModelRequest): GetModelResponse

    /**
     * Gets a Model.
     */
    suspend fun getModel(block: GetModelRequest.Builder.() -> Unit) = getModel(GetModelRequest.Builder().apply(block).build())

    /**
     * Gets a model template.
     */
    suspend fun getModelTemplate(input: GetModelTemplateRequest): GetModelTemplateResponse

    /**
     * Gets a model template.
     */
    suspend fun getModelTemplate(block: GetModelTemplateRequest.Builder.() -> Unit) = getModelTemplate(GetModelTemplateRequest.Builder().apply(block).build())

    /**
     * Gets the Models for an API.
     */
    suspend fun getModels(input: GetModelsRequest): GetModelsResponse

    /**
     * Gets the Models for an API.
     */
    suspend fun getModels(block: GetModelsRequest.Builder.() -> Unit) = getModels(GetModelsRequest.Builder().apply(block).build())

    /**
     * Gets a Route.
     */
    suspend fun getRoute(input: GetRouteRequest): GetRouteResponse

    /**
     * Gets a Route.
     */
    suspend fun getRoute(block: GetRouteRequest.Builder.() -> Unit) = getRoute(GetRouteRequest.Builder().apply(block).build())

    /**
     * Gets a RouteResponse.
     */
    suspend fun getRouteResponse(input: GetRouteResponseRequest): GetRouteResponseResponse

    /**
     * Gets a RouteResponse.
     */
    suspend fun getRouteResponse(block: GetRouteResponseRequest.Builder.() -> Unit) = getRouteResponse(GetRouteResponseRequest.Builder().apply(block).build())

    /**
     * Gets the RouteResponses for a Route.
     */
    suspend fun getRouteResponses(input: GetRouteResponsesRequest): GetRouteResponsesResponse

    /**
     * Gets the RouteResponses for a Route.
     */
    suspend fun getRouteResponses(block: GetRouteResponsesRequest.Builder.() -> Unit) = getRouteResponses(GetRouteResponsesRequest.Builder().apply(block).build())

    /**
     * Gets the Routes for an API.
     */
    suspend fun getRoutes(input: GetRoutesRequest): GetRoutesResponse

    /**
     * Gets the Routes for an API.
     */
    suspend fun getRoutes(block: GetRoutesRequest.Builder.() -> Unit) = getRoutes(GetRoutesRequest.Builder().apply(block).build())

    /**
     * Gets a Stage.
     */
    suspend fun getStage(input: GetStageRequest): GetStageResponse

    /**
     * Gets a Stage.
     */
    suspend fun getStage(block: GetStageRequest.Builder.() -> Unit) = getStage(GetStageRequest.Builder().apply(block).build())

    /**
     * Gets the Stages for an API.
     */
    suspend fun getStages(input: GetStagesRequest): GetStagesResponse

    /**
     * Gets the Stages for an API.
     */
    suspend fun getStages(block: GetStagesRequest.Builder.() -> Unit) = getStages(GetStagesRequest.Builder().apply(block).build())

    /**
     * Gets a collection of Tag resources.
     */
    suspend fun getTags(input: GetTagsRequest): GetTagsResponse

    /**
     * Gets a collection of Tag resources.
     */
    suspend fun getTags(block: GetTagsRequest.Builder.() -> Unit) = getTags(GetTagsRequest.Builder().apply(block).build())

    /**
     * Gets a VPC link.
     */
    suspend fun getVpcLink(input: GetVpcLinkRequest): GetVpcLinkResponse

    /**
     * Gets a VPC link.
     */
    suspend fun getVpcLink(block: GetVpcLinkRequest.Builder.() -> Unit) = getVpcLink(GetVpcLinkRequest.Builder().apply(block).build())

    /**
     * Gets a collection of VPC links.
     */
    suspend fun getVpcLinks(input: GetVpcLinksRequest = GetVpcLinksRequest {}): GetVpcLinksResponse

    /**
     * Gets a collection of VPC links.
     */
    suspend fun getVpcLinks(block: GetVpcLinksRequest.Builder.() -> Unit) = getVpcLinks(GetVpcLinksRequest.Builder().apply(block).build())

    /**
     * Imports an API.
     */
    suspend fun importApi(input: ImportApiRequest): ImportApiResponse

    /**
     * Imports an API.
     */
    suspend fun importApi(block: ImportApiRequest.Builder.() -> Unit) = importApi(ImportApiRequest.Builder().apply(block).build())

    /**
     * Puts an Api resource.
     */
    suspend fun reimportApi(input: ReimportApiRequest): ReimportApiResponse

    /**
     * Puts an Api resource.
     */
    suspend fun reimportApi(block: ReimportApiRequest.Builder.() -> Unit) = reimportApi(ReimportApiRequest.Builder().apply(block).build())

    /**
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     */
    suspend fun resetAuthorizersCache(input: ResetAuthorizersCacheRequest): ResetAuthorizersCacheResponse

    /**
     * Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.
     */
    suspend fun resetAuthorizersCache(block: ResetAuthorizersCacheRequest.Builder.() -> Unit) = resetAuthorizersCache(ResetAuthorizersCacheRequest.Builder().apply(block).build())

    /**
     * Creates a new Tag resource to represent a tag.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Creates a new Tag resource to represent a tag.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Deletes a Tag.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Deletes a Tag.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates an Api resource.
     */
    suspend fun updateApi(input: UpdateApiRequest): UpdateApiResponse

    /**
     * Updates an Api resource.
     */
    suspend fun updateApi(block: UpdateApiRequest.Builder.() -> Unit) = updateApi(UpdateApiRequest.Builder().apply(block).build())

    /**
     * The API mapping.
     */
    suspend fun updateApiMapping(input: UpdateApiMappingRequest): UpdateApiMappingResponse

    /**
     * The API mapping.
     */
    suspend fun updateApiMapping(block: UpdateApiMappingRequest.Builder.() -> Unit) = updateApiMapping(UpdateApiMappingRequest.Builder().apply(block).build())

    /**
     * Updates an Authorizer.
     */
    suspend fun updateAuthorizer(input: UpdateAuthorizerRequest): UpdateAuthorizerResponse

    /**
     * Updates an Authorizer.
     */
    suspend fun updateAuthorizer(block: UpdateAuthorizerRequest.Builder.() -> Unit) = updateAuthorizer(UpdateAuthorizerRequest.Builder().apply(block).build())

    /**
     * Updates a Deployment.
     */
    suspend fun updateDeployment(input: UpdateDeploymentRequest): UpdateDeploymentResponse

    /**
     * Updates a Deployment.
     */
    suspend fun updateDeployment(block: UpdateDeploymentRequest.Builder.() -> Unit) = updateDeployment(UpdateDeploymentRequest.Builder().apply(block).build())

    /**
     * Updates a domain name.
     */
    suspend fun updateDomainName(input: UpdateDomainNameRequest): UpdateDomainNameResponse

    /**
     * Updates a domain name.
     */
    suspend fun updateDomainName(block: UpdateDomainNameRequest.Builder.() -> Unit) = updateDomainName(UpdateDomainNameRequest.Builder().apply(block).build())

    /**
     * Updates an Integration.
     */
    suspend fun updateIntegration(input: UpdateIntegrationRequest): UpdateIntegrationResponse

    /**
     * Updates an Integration.
     */
    suspend fun updateIntegration(block: UpdateIntegrationRequest.Builder.() -> Unit) = updateIntegration(UpdateIntegrationRequest.Builder().apply(block).build())

    /**
     * Updates an IntegrationResponses.
     */
    suspend fun updateIntegrationResponse(input: UpdateIntegrationResponseRequest): UpdateIntegrationResponseResponse

    /**
     * Updates an IntegrationResponses.
     */
    suspend fun updateIntegrationResponse(block: UpdateIntegrationResponseRequest.Builder.() -> Unit) = updateIntegrationResponse(UpdateIntegrationResponseRequest.Builder().apply(block).build())

    /**
     * Updates a Model.
     */
    suspend fun updateModel(input: UpdateModelRequest): UpdateModelResponse

    /**
     * Updates a Model.
     */
    suspend fun updateModel(block: UpdateModelRequest.Builder.() -> Unit) = updateModel(UpdateModelRequest.Builder().apply(block).build())

    /**
     * Updates a Route.
     */
    suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse

    /**
     * Updates a Route.
     */
    suspend fun updateRoute(block: UpdateRouteRequest.Builder.() -> Unit) = updateRoute(UpdateRouteRequest.Builder().apply(block).build())

    /**
     * Updates a RouteResponse.
     */
    suspend fun updateRouteResponse(input: UpdateRouteResponseRequest): UpdateRouteResponseResponse

    /**
     * Updates a RouteResponse.
     */
    suspend fun updateRouteResponse(block: UpdateRouteResponseRequest.Builder.() -> Unit) = updateRouteResponse(UpdateRouteResponseRequest.Builder().apply(block).build())

    /**
     * Updates a Stage.
     */
    suspend fun updateStage(input: UpdateStageRequest): UpdateStageResponse

    /**
     * Updates a Stage.
     */
    suspend fun updateStage(block: UpdateStageRequest.Builder.() -> Unit) = updateStage(UpdateStageRequest.Builder().apply(block).build())

    /**
     * Updates a VPC link.
     */
    suspend fun updateVpcLink(input: UpdateVpcLinkRequest): UpdateVpcLinkResponse

    /**
     * Updates a VPC link.
     */
    suspend fun updateVpcLink(block: UpdateVpcLinkRequest.Builder.() -> Unit) = updateVpcLink(UpdateVpcLinkRequest.Builder().apply(block).build())
}
