// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Updates an IntegrationResponses.
 */
class UpdateIntegrationResponseRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     *
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     *
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    val contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = builder.contentHandlingStrategy
    /**
     * The integration ID.
     */
    val integrationId: kotlin.String? = requireNotNull(builder.integrationId) { "A non-null value must be provided for integrationId" }
    /**
     * The integration response ID.
     */
    val integrationResponseId: kotlin.String? = requireNotNull(builder.integrationResponseId) { "A non-null value must be provided for integrationResponseId" }
    /**
     * The integration response key.
     */
    val integrationResponseKey: kotlin.String? = builder.integrationResponseKey
    /**
     * A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>{name} , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>{name} or integration.response.body.<replaceable>{JSON-expression} , where <replaceable>{name} is a valid and unique response header name and <replaceable>{JSON-expression} is a valid JSON expression without the $ prefix.
     */
    val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     */
    val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * The template selection expression for the integration response. Supported only for WebSocket APIs.
     */
    val templateSelectionExpression: kotlin.String? = builder.templateSelectionExpression

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIntegrationResponseRequest(")
        append("apiId=$apiId,")
        append("contentHandlingStrategy=$contentHandlingStrategy,")
        append("integrationId=$integrationId,")
        append("integrationResponseId=$integrationResponseId,")
        append("integrationResponseKey=$integrationResponseKey,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("templateSelectionExpression=$templateSelectionExpression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (contentHandlingStrategy?.hashCode() ?: 0)
        result = 31 * result + (integrationId?.hashCode() ?: 0)
        result = 31 * result + (integrationResponseId?.hashCode() ?: 0)
        result = 31 * result + (integrationResponseKey?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (templateSelectionExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIntegrationResponseRequest

        if (apiId != other.apiId) return false
        if (contentHandlingStrategy != other.contentHandlingStrategy) return false
        if (integrationId != other.integrationId) return false
        if (integrationResponseId != other.integrationResponseId) return false
        if (integrationResponseKey != other.integrationResponseKey) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (templateSelectionExpression != other.templateSelectionExpression) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The API identifier.
         */
        var apiId: kotlin.String? = null
        /**
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         *
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         *
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *
         * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         */
        var contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = null
        /**
         * The integration ID.
         */
        var integrationId: kotlin.String? = null
        /**
         * The integration response ID.
         */
        var integrationResponseId: kotlin.String? = null
        /**
         * The integration response key.
         */
        var integrationResponseKey: kotlin.String? = null
        /**
         * A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.<replaceable>{name} , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.<replaceable>{name} or integration.response.body.<replaceable>{JSON-expression} , where <replaceable>{name} is a valid and unique response header name and <replaceable>{JSON-expression} is a valid JSON expression without the $ prefix.
         */
        var responseParameters: Map<String, String>? = null
        /**
         * The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         */
        var responseTemplates: Map<String, String>? = null
        /**
         * The template selection expression for the integration response. Supported only for WebSocket APIs.
         */
        var templateSelectionExpression: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest) : this() {
            this.apiId = x.apiId
            this.contentHandlingStrategy = x.contentHandlingStrategy
            this.integrationId = x.integrationId
            this.integrationResponseId = x.integrationResponseId
            this.integrationResponseKey = x.integrationResponseKey
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.templateSelectionExpression = x.templateSelectionExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest = UpdateIntegrationResponseRequest(this)
    }
}
