// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Represents a CORS configuration. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
 */
class Cors private constructor(builder: Builder) {
    /**
     * Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
     */
    val allowCredentials: kotlin.Boolean? = builder.allowCredentials
    /**
     * Represents a collection of allowed headers. Supported only for HTTP APIs.
     */
    val allowHeaders: List<String>? = builder.allowHeaders
    /**
     * Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
     */
    val allowMethods: List<String>? = builder.allowMethods
    /**
     * Represents a collection of allowed origins. Supported only for HTTP APIs.
     */
    val allowOrigins: List<String>? = builder.allowOrigins
    /**
     * Represents a collection of exposed headers. Supported only for HTTP APIs.
     */
    val exposeHeaders: List<String>? = builder.exposeHeaders
    /**
     * The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
     */
    val maxAge: kotlin.Int? = builder.maxAge

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.Cors = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cors(")
        append("allowCredentials=$allowCredentials,")
        append("allowHeaders=$allowHeaders,")
        append("allowMethods=$allowMethods,")
        append("allowOrigins=$allowOrigins,")
        append("exposeHeaders=$exposeHeaders,")
        append("maxAge=$maxAge)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowCredentials?.hashCode() ?: 0
        result = 31 * result + (allowHeaders?.hashCode() ?: 0)
        result = 31 * result + (allowMethods?.hashCode() ?: 0)
        result = 31 * result + (allowOrigins?.hashCode() ?: 0)
        result = 31 * result + (exposeHeaders?.hashCode() ?: 0)
        result = 31 * result + (maxAge ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cors

        if (allowCredentials != other.allowCredentials) return false
        if (allowHeaders != other.allowHeaders) return false
        if (allowMethods != other.allowMethods) return false
        if (allowOrigins != other.allowOrigins) return false
        if (exposeHeaders != other.exposeHeaders) return false
        if (maxAge != other.maxAge) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.Cors = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether credentials are included in the CORS request. Supported only for HTTP APIs.
         */
        var allowCredentials: kotlin.Boolean? = null
        /**
         * Represents a collection of allowed headers. Supported only for HTTP APIs.
         */
        var allowHeaders: List<String>? = null
        /**
         * Represents a collection of allowed HTTP methods. Supported only for HTTP APIs.
         */
        var allowMethods: List<String>? = null
        /**
         * Represents a collection of allowed origins. Supported only for HTTP APIs.
         */
        var allowOrigins: List<String>? = null
        /**
         * Represents a collection of exposed headers. Supported only for HTTP APIs.
         */
        var exposeHeaders: List<String>? = null
        /**
         * The number of seconds that the browser should cache preflight request results. Supported only for HTTP APIs.
         */
        var maxAge: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.Cors) : this() {
            this.allowCredentials = x.allowCredentials
            this.allowHeaders = x.allowHeaders
            this.allowMethods = x.allowMethods
            this.allowOrigins = x.allowOrigins
            this.exposeHeaders = x.exposeHeaders
            this.maxAge = x.maxAge
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.Cors = Cors(this)
    }
}
