// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



class CreateAuthorizerResponse private constructor(builder: Builder) {
    /**
     * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.
     */
    val authorizerCredentialsArn: kotlin.String? = builder.authorizerCredentialsArn
    /**
     * The authorizer identifier.
     */
    val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
     */
    val authorizerPayloadFormatVersion: kotlin.String? = builder.authorizerPayloadFormatVersion
    /**
     * The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.
     */
    val authorizerResultTtlInSeconds: kotlin.Int? = builder.authorizerResultTtlInSeconds
    /**
     * The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).
     */
    val authorizerType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizerType? = builder.authorizerType
    /**
     * The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}:function:<replaceable>{lambda_function_name}/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}:lambda:path/<replaceable>{service_api} , where <replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/&#91;FunctionARN&#93;/invocations. Supported only for REQUEST authorizers.
     */
    val authorizerUri: kotlin.String? = builder.authorizerUri
    /**
     * Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html)
     */
    val enableSimpleResponses: kotlin.Boolean? = builder.enableSimpleResponses
    /**
     * The identity source for which authorization is requested.
     *
     * For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
     *
     * For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.
     */
    val identitySource: List<String>? = builder.identitySource
    /**
     * The validation expression does not apply to the REQUEST authorizer.
     */
    val identityValidationExpression: kotlin.String? = builder.identityValidationExpression
    /**
     * Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.
     */
    val jwtConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration? = builder.jwtConfiguration
    /**
     * The name of the authorizer.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAuthorizerResponse(")
        append("authorizerCredentialsArn=$authorizerCredentialsArn,")
        append("authorizerId=$authorizerId,")
        append("authorizerPayloadFormatVersion=$authorizerPayloadFormatVersion,")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerType=$authorizerType,")
        append("authorizerUri=$authorizerUri,")
        append("enableSimpleResponses=$enableSimpleResponses,")
        append("identitySource=$identitySource,")
        append("identityValidationExpression=$identityValidationExpression,")
        append("jwtConfiguration=$jwtConfiguration,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerCredentialsArn?.hashCode() ?: 0
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (authorizerPayloadFormatVersion?.hashCode() ?: 0)
        result = 31 * result + (authorizerResultTtlInSeconds ?: 0)
        result = 31 * result + (authorizerType?.hashCode() ?: 0)
        result = 31 * result + (authorizerUri?.hashCode() ?: 0)
        result = 31 * result + (enableSimpleResponses?.hashCode() ?: 0)
        result = 31 * result + (identitySource?.hashCode() ?: 0)
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        result = 31 * result + (jwtConfiguration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAuthorizerResponse

        if (authorizerCredentialsArn != other.authorizerCredentialsArn) return false
        if (authorizerId != other.authorizerId) return false
        if (authorizerPayloadFormatVersion != other.authorizerPayloadFormatVersion) return false
        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerType != other.authorizerType) return false
        if (authorizerUri != other.authorizerUri) return false
        if (enableSimpleResponses != other.enableSimpleResponses) return false
        if (identitySource != other.identitySource) return false
        if (identityValidationExpression != other.identityValidationExpression) return false
        if (jwtConfiguration != other.jwtConfiguration) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers.
         */
        var authorizerCredentialsArn: kotlin.String? = null
        /**
         * The authorizer identifier.
         */
        var authorizerId: kotlin.String? = null
        /**
         * Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
         */
        var authorizerPayloadFormatVersion: kotlin.String? = null
        /**
         * The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers.
         */
        var authorizerResultTtlInSeconds: kotlin.Int? = null
        /**
         * The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).
         */
        var authorizerType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizerType? = null
        /**
         * The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:<replaceable>{account_id}:function:<replaceable>{lambda_function_name}/invocations. In general, the URI has this form: arn:aws:apigateway:<replaceable>{region}:lambda:path/<replaceable>{service_api} , where <replaceable>{region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/&#91;FunctionARN&#93;/invocations. Supported only for REQUEST authorizers.
         */
        var authorizerUri: kotlin.String? = null
        /**
         * Specifies whether a Lambda authorizer returns a response in a simple format. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html)
         */
        var enableSimpleResponses: kotlin.Boolean? = null
        /**
         * The identity source for which authorization is requested.
         *
         * For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see [Working with AWS Lambda authorizers for HTTP APIs](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html).
         *
         * For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.
         */
        var identitySource: List<String>? = null
        /**
         * The validation expression does not apply to the REQUEST authorizer.
         */
        var identityValidationExpression: kotlin.String? = null
        /**
         * Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.
         */
        var jwtConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration? = null
        /**
         * The name of the authorizer.
         */
        var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse) : this() {
            this.authorizerCredentialsArn = x.authorizerCredentialsArn
            this.authorizerId = x.authorizerId
            this.authorizerPayloadFormatVersion = x.authorizerPayloadFormatVersion
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerType = x.authorizerType
            this.authorizerUri = x.authorizerUri
            this.enableSimpleResponses = x.enableSimpleResponses
            this.identitySource = x.identitySource
            this.identityValidationExpression = x.identityValidationExpression
            this.jwtConfiguration = x.jwtConfiguration
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse = CreateAuthorizerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration] inside the given [block]
         */
        fun jwtConfiguration(block: aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration.Builder.() -> kotlin.Unit) {
            this.jwtConfiguration = aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration.invoke(block)
        }
    }
}
