// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs.
 */
class JwtConfiguration private constructor(builder: Builder) {
    /**
     * A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See [RFC 7519](https://tools.ietf.org/html/rfc7519#section-4.1.3). Supported only for HTTP APIs.
     */
    val audience: List<String>? = builder.audience
    /**
     * The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}.amazonaws.com/<replaceable>{userPoolId} . Required for the JWT authorizer type. Supported only for HTTP APIs.
     */
    val issuer: kotlin.String? = builder.issuer

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JwtConfiguration(")
        append("audience=$audience,")
        append("issuer=$issuer)")
    }

    override fun hashCode(): kotlin.Int {
        var result = audience?.hashCode() ?: 0
        result = 31 * result + (issuer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JwtConfiguration

        if (audience != other.audience) return false
        if (issuer != other.issuer) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list. See [RFC 7519](https://tools.ietf.org/html/rfc7519#section-4.1.3). Supported only for HTTP APIs.
         */
        var audience: List<String>? = null
        /**
         * The base domain of the identity provider that issues JSON Web Tokens. For example, an Amazon Cognito user pool has the following format: https://cognito-idp.<replaceable>{region}.amazonaws.com/<replaceable>{userPoolId} . Required for the JWT authorizer type. Supported only for HTTP APIs.
         */
        var issuer: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration) : this() {
            this.audience = x.audience
            this.issuer = x.issuer
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration = JwtConfiguration(this)
    }
}
