// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



public class ExportApiRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    public val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.
     */
    public val exportVersion: kotlin.String? = builder.exportVersion
    /**
     * Specifies whether to include [API Gateway extensions](https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html) in the exported API definition. API Gateway extensions are included by default.
     */
    public val includeExtensions: kotlin.Boolean = builder.includeExtensions
    /**
     * The output type of the exported definition file. Valid values are JSON and YAML.
     */
    public val outputType: kotlin.String? = requireNotNull(builder.outputType) { "A non-null value must be provided for outputType" }
    /**
     * The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
     */
    public val specification: kotlin.String? = requireNotNull(builder.specification) { "A non-null value must be provided for specification" }
    /**
     * The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.
     */
    public val stageName: kotlin.String? = builder.stageName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportApiRequest(")
        append("apiId=$apiId,")
        append("exportVersion=$exportVersion,")
        append("includeExtensions=$includeExtensions,")
        append("outputType=$outputType,")
        append("specification=$specification,")
        append("stageName=$stageName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (exportVersion?.hashCode() ?: 0)
        result = 31 * result + (includeExtensions.hashCode())
        result = 31 * result + (outputType?.hashCode() ?: 0)
        result = 31 * result + (specification?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportApiRequest

        if (apiId != other.apiId) return false
        if (exportVersion != other.exportVersion) return false
        if (includeExtensions != other.includeExtensions) return false
        if (outputType != other.outputType) return false
        if (specification != other.specification) return false
        if (stageName != other.stageName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API identifier.
         */
        public var apiId: kotlin.String? = null
        /**
         * The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0.
         */
        public var exportVersion: kotlin.String? = null
        /**
         * Specifies whether to include [API Gateway extensions](https://docs.aws.amazon.com//apigateway/latest/developerguide/api-gateway-swagger-extensions.html) in the exported API definition. API Gateway extensions are included by default.
         */
        public var includeExtensions: kotlin.Boolean = false
        /**
         * The output type of the exported definition file. Valid values are JSON and YAML.
         */
        public var outputType: kotlin.String? = null
        /**
         * The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
         */
        public var specification: kotlin.String? = null
        /**
         * The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported.
         */
        public var stageName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest) : this() {
            this.apiId = x.apiId
            this.exportVersion = x.exportVersion
            this.includeExtensions = x.includeExtensions
            this.outputType = x.outputType
            this.specification = x.specification
            this.stageName = x.stageName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest = ExportApiRequest(this)
    }
}
