// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.CreateVpcLinkResponse
import aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkStatus
import aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkVersion
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateVpcLinkOperationDeserializer: HttpDeserialize<CreateVpcLinkResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateVpcLinkResponse {
        if (!response.status.isSuccess()) {
            throwCreateVpcLinkError(context, response)
        }
        val builder = CreateVpcLinkResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateVpcLinkOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateVpcLinkError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateVpcLinkOperationBody(builder: CreateVpcLinkResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("securityGroupIds"))
    val SUBNETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subnetIds"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VPCLINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkId"))
    val VPCLINKSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkStatus"))
    val VPCLINKSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkStatusMessage"))
    val VPCLINKVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcLinkVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDDATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SUBNETIDS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCLINKID_DESCRIPTOR)
        field(VPCLINKSTATUS_DESCRIPTOR)
        field(VPCLINKSTATUSMESSAGE_DESCRIPTOR)
        field(VPCLINKVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromIso8601(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SECURITYGROUPIDS_DESCRIPTOR.index -> builder.securityGroupIds =
                    deserializer.deserializeList(SECURITYGROUPIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBNETIDS_DESCRIPTOR.index -> builder.subnetIds =
                    deserializer.deserializeList(SUBNETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VPCLINKID_DESCRIPTOR.index -> builder.vpcLinkId = deserializeString()
                VPCLINKSTATUS_DESCRIPTOR.index -> builder.vpcLinkStatus = deserializeString().let { VpcLinkStatus.fromValue(it) }
                VPCLINKSTATUSMESSAGE_DESCRIPTOR.index -> builder.vpcLinkStatusMessage = deserializeString()
                VPCLINKVERSION_DESCRIPTOR.index -> builder.vpcLinkVersion = deserializeString().let { VpcLinkVersion.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
