// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



public class UpdateRouteResponse private constructor(builder: Builder) {
    /**
     * Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.
     */
    public val apiGatewayManaged: kotlin.Boolean = builder.apiGatewayManaged
    /**
     * Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
     */
    public val apiKeyRequired: kotlin.Boolean = builder.apiKeyRequired
    /**
     * A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    public val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
     */
    public val authorizationType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType? = builder.authorizationType
    /**
     * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.
     */
    public val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * The model selection expression for the route. Supported only for WebSocket APIs.
     */
    public val modelSelectionExpression: kotlin.String? = builder.modelSelectionExpression
    /**
     * The operation name for the route.
     */
    public val operationName: kotlin.String? = builder.operationName
    /**
     * The request models for the route. Supported only for WebSocket APIs.
     */
    public val requestModels: Map<String, String>? = builder.requestModels
    /**
     * The request parameters for the route. Supported only for WebSocket APIs.
     */
    public val requestParameters: Map<String, ParameterConstraints>? = builder.requestParameters
    /**
     * The route ID.
     */
    public val routeId: kotlin.String? = builder.routeId
    /**
     * The route key for the route.
     */
    public val routeKey: kotlin.String? = builder.routeKey
    /**
     * The route response selection expression for the route. Supported only for WebSocket APIs.
     */
    public val routeResponseSelectionExpression: kotlin.String? = builder.routeResponseSelectionExpression
    /**
     * The target for the route.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRouteResponse(")
        append("apiGatewayManaged=$apiGatewayManaged,")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("modelSelectionExpression=$modelSelectionExpression,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("routeId=$routeId,")
        append("routeKey=$routeKey,")
        append("routeResponseSelectionExpression=$routeResponseSelectionExpression,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiGatewayManaged.hashCode()
        result = 31 * result + (apiKeyRequired.hashCode())
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (modelSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (routeId?.hashCode() ?: 0)
        result = 31 * result + (routeKey?.hashCode() ?: 0)
        result = 31 * result + (routeResponseSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRouteResponse

        if (apiGatewayManaged != other.apiGatewayManaged) return false
        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (modelSelectionExpression != other.modelSelectionExpression) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (routeId != other.routeId) return false
        if (routeKey != other.routeKey) return false
        if (routeResponseSelectionExpression != other.routeResponseSelectionExpression) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether a route is managed by API Gateway. If you created an API using quick create, the $default route is managed by API Gateway. You can't modify the $default route key.
         */
        public var apiGatewayManaged: kotlin.Boolean = false
        /**
         * Specifies whether an API key is required for this route. Supported only for WebSocket APIs.
         */
        public var apiKeyRequired: kotlin.Boolean = false
        /**
         * A list of authorization scopes configured on a route. The scopes are used with a JWT authorizer to authorize the method invocation. The authorization works by matching the route scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any route scope matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the route scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         */
        public var authorizationScopes: List<String>? = null
        /**
         * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
         */
        public var authorizationType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType? = null
        /**
         * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.
         */
        public var authorizerId: kotlin.String? = null
        /**
         * The model selection expression for the route. Supported only for WebSocket APIs.
         */
        public var modelSelectionExpression: kotlin.String? = null
        /**
         * The operation name for the route.
         */
        public var operationName: kotlin.String? = null
        /**
         * The request models for the route. Supported only for WebSocket APIs.
         */
        public var requestModels: Map<String, String>? = null
        /**
         * The request parameters for the route. Supported only for WebSocket APIs.
         */
        public var requestParameters: Map<String, ParameterConstraints>? = null
        /**
         * The route ID.
         */
        public var routeId: kotlin.String? = null
        /**
         * The route key for the route.
         */
        public var routeKey: kotlin.String? = null
        /**
         * The route response selection expression for the route. Supported only for WebSocket APIs.
         */
        public var routeResponseSelectionExpression: kotlin.String? = null
        /**
         * The target for the route.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse) : this() {
            this.apiGatewayManaged = x.apiGatewayManaged
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.modelSelectionExpression = x.modelSelectionExpression
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.routeId = x.routeId
            this.routeKey = x.routeKey
            this.routeResponseSelectionExpression = x.routeResponseSelectionExpression
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse = UpdateRouteResponse(this)
    }
}
