// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.ConnectionType
import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.IntegrationType
import aws.sdk.kotlin.services.apigatewayv2.model.PassthroughBehavior
import aws.sdk.kotlin.services.apigatewayv2.model.TlsConfigInput
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateIntegrationOperationSerializer: HttpSerialize<UpdateIntegrationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateIntegrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "integrations",
                "${input.integrationId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateIntegrationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateIntegrationOperationBody(context: ExecutionContext, input: UpdateIntegrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CONNECTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionType"))
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentHandlingStrategy"))
    val CREDENTIALSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialsArn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INTEGRATIONMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationMethod"))
    val INTEGRATIONSUBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationSubtype"))
    val INTEGRATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationType"))
    val INTEGRATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationUri"))
    val PASSTHROUGHBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("passthroughBehavior"))
    val PAYLOADFORMATVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("payloadFormatVersion"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTTEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestTemplates"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSEPARAMETERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val TIMEOUTINMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutInMillis"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONTYPE_DESCRIPTOR)
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(CREDENTIALSARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INTEGRATIONMETHOD_DESCRIPTOR)
        field(INTEGRATIONSUBTYPE_DESCRIPTOR)
        field(INTEGRATIONTYPE_DESCRIPTOR)
        field(INTEGRATIONURI_DESCRIPTOR)
        field(PASSTHROUGHBEHAVIOR_DESCRIPTOR)
        field(PAYLOADFORMATVERSION_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTTEMPLATES_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
        field(TIMEOUTINMILLIS_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.connectionId?.let { field(CONNECTIONID_DESCRIPTOR, it) }
        input.connectionType?.let { field(CONNECTIONTYPE_DESCRIPTOR, it.value) }
        input.contentHandlingStrategy?.let { field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR, it.value) }
        input.credentialsArn?.let { field(CREDENTIALSARN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.integrationMethod?.let { field(INTEGRATIONMETHOD_DESCRIPTOR, it) }
        input.integrationSubtype?.let { field(INTEGRATIONSUBTYPE_DESCRIPTOR, it) }
        input.integrationType?.let { field(INTEGRATIONTYPE_DESCRIPTOR, it.value) }
        input.integrationUri?.let { field(INTEGRATIONURI_DESCRIPTOR, it) }
        input.passthroughBehavior?.let { field(PASSTHROUGHBEHAVIOR_DESCRIPTOR, it.value) }
        input.payloadFormatVersion?.let { field(PAYLOADFORMATVERSION_DESCRIPTOR, it) }
        if (input.requestParameters != null) {
            mapField(REQUESTPARAMETERS_DESCRIPTOR) {
                input.requestParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.requestTemplates != null) {
            mapField(REQUESTTEMPLATES_DESCRIPTOR) {
                input.requestTemplates.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) ->
                    mapEntry(key, RESPONSEPARAMETERS_C0_DESCRIPTOR) {
                        value.forEach { (key1, value1) -> entry(key1, value1) }
                    }
                }
            }
        }
        input.templateSelectionExpression?.let { field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR, it) }
        if (input.timeoutInMillis != 0) field(TIMEOUTINMILLIS_DESCRIPTOR, input.timeoutInMillis)
        input.tlsConfig?.let { field(TLSCONFIG_DESCRIPTOR, it, ::serializeTlsConfigInputDocument) }
    }
    return serializer.toByteArray()
}
