// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.GetIntegrationResponseResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetIntegrationResponseOperationDeserializer: HttpDeserialize<GetIntegrationResponseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetIntegrationResponseResponse {
        if (!response.status.isSuccess()) {
            throwGetIntegrationResponseError(context, response)
        }
        val builder = GetIntegrationResponseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetIntegrationResponseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetIntegrationResponseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIntegrationResponseOperationBody(builder: GetIntegrationResponseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentHandlingStrategy"))
    val INTEGRATIONRESPONSEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseId"))
    val INTEGRATIONRESPONSEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseKey"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(INTEGRATIONRESPONSEID_DESCRIPTOR)
        field(INTEGRATIONRESPONSEKEY_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENTHANDLINGSTRATEGY_DESCRIPTOR.index -> builder.contentHandlingStrategy = deserializeString().let { ContentHandlingStrategy.fromValue(it) }
                INTEGRATIONRESPONSEID_DESCRIPTOR.index -> builder.integrationResponseId = deserializeString()
                INTEGRATIONRESPONSEKEY_DESCRIPTOR.index -> builder.integrationResponseKey = deserializeString()
                RESPONSEPARAMETERS_DESCRIPTOR.index -> builder.responseParameters =
                    deserializer.deserializeMap(RESPONSEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESPONSETEMPLATES_DESCRIPTOR.index -> builder.responseTemplates =
                    deserializer.deserializeMap(RESPONSETEMPLATES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.templateSelectionExpression = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
