// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



public class UpdateIntegrationResponseResponse private constructor(builder: Builder) {
    /**
     * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
     *
     * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     *
     * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
     *
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    public val contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = builder.contentHandlingStrategy
    /**
     * The integration response ID.
     */
    public val integrationResponseId: kotlin.String? = builder.integrationResponseId
    /**
     * The integration response key.
     */
    public val integrationResponseKey: kotlin.String? = builder.integrationResponseKey
    /**
     * A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
     */
    public val responseParameters: Map<String, String>? = builder.responseParameters
    /**
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     */
    public val responseTemplates: Map<String, String>? = builder.responseTemplates
    /**
     * The template selection expressions for the integration response.
     */
    public val templateSelectionExpression: kotlin.String? = builder.templateSelectionExpression

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIntegrationResponseResponse(")
        append("contentHandlingStrategy=$contentHandlingStrategy,")
        append("integrationResponseId=$integrationResponseId,")
        append("integrationResponseKey=$integrationResponseKey,")
        append("responseParameters=$responseParameters,")
        append("responseTemplates=$responseTemplates,")
        append("templateSelectionExpression=$templateSelectionExpression")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentHandlingStrategy?.hashCode() ?: 0
        result = 31 * result + (integrationResponseId?.hashCode() ?: 0)
        result = 31 * result + (integrationResponseKey?.hashCode() ?: 0)
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (responseTemplates?.hashCode() ?: 0)
        result = 31 * result + (templateSelectionExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIntegrationResponseResponse

        if (contentHandlingStrategy != other.contentHandlingStrategy) return false
        if (integrationResponseId != other.integrationResponseId) return false
        if (integrationResponseKey != other.integrationResponseKey) return false
        if (responseParameters != other.responseParameters) return false
        if (responseTemplates != other.responseTemplates) return false
        if (templateSelectionExpression != other.templateSelectionExpression) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
         *
         * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         *
         * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.
         *
         * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         */
        public var contentHandlingStrategy: aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy? = null
        /**
         * The integration response ID.
         */
        public var integrationResponseId: kotlin.String? = null
        /**
         * The integration response key.
         */
        public var integrationResponseKey: kotlin.String? = null
        /**
         * A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name is a valid and unique response header name and JSON-expression is a valid JSON expression without the $ prefix.
         */
        public var responseParameters: Map<String, String>? = null
        /**
         * The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         */
        public var responseTemplates: Map<String, String>? = null
        /**
         * The template selection expressions for the integration response.
         */
        public var templateSelectionExpression: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseResponse) : this() {
            this.contentHandlingStrategy = x.contentHandlingStrategy
            this.integrationResponseId = x.integrationResponseId
            this.integrationResponseKey = x.integrationResponseKey
            this.responseParameters = x.responseParameters
            this.responseTemplates = x.responseTemplates
            this.templateSelectionExpression = x.templateSelectionExpression
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseResponse = UpdateIntegrationResponseResponse(this)
    }
}
