// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.Cors
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApiOperationSerializer: HttpSerialize<UpdateApiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateApiOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateApiOperationBody(context: ExecutionContext, input: UpdateApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIKEYSELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiKeySelectionExpression"))
    val CORSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("corsConfiguration"))
    val CREDENTIALSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialsArn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableExecuteApiEndpoint"))
    val DISABLESCHEMAVALIDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableSchemaValidation"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ROUTEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeKey"))
    val ROUTESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeSelectionExpression"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("target"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYSELECTIONEXPRESSION_DESCRIPTOR)
        field(CORSCONFIGURATION_DESCRIPTOR)
        field(CREDENTIALSARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR)
        field(DISABLESCHEMAVALIDATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROUTEKEY_DESCRIPTOR)
        field(ROUTESELECTIONEXPRESSION_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiKeySelectionExpression?.let { field(APIKEYSELECTIONEXPRESSION_DESCRIPTOR, it) }
        input.corsConfiguration?.let { field(CORSCONFIGURATION_DESCRIPTOR, it, ::serializeCorsDocument) }
        input.credentialsArn?.let { field(CREDENTIALSARN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.disableExecuteApiEndpoint?.let { field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR, it) }
        input.disableSchemaValidation?.let { field(DISABLESCHEMAVALIDATION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.routeKey?.let { field(ROUTEKEY_DESCRIPTOR, it) }
        input.routeSelectionExpression?.let { field(ROUTESELECTIONEXPRESSION_DESCRIPTOR, it) }
        input.target?.let { field(TARGET_DESCRIPTOR, it) }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
