// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Creates a new Route resource to represent a route.
 */
public class CreateRouteRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    public val apiId: kotlin.String? = requireNotNull(builder.apiId) { "A non-null value must be provided for apiId" }
    /**
     * Specifies whether an API key is required for the route. Supported only for WebSocket APIs.
     */
    public val apiKeyRequired: kotlin.Boolean? = builder.apiKeyRequired
    /**
     * The authorization scopes supported by this route.
     */
    public val authorizationScopes: List<String>? = builder.authorizationScopes
    /**
     * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
     */
    public val authorizationType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType? = builder.authorizationType
    /**
     * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.
     */
    public val authorizerId: kotlin.String? = builder.authorizerId
    /**
     * The model selection expression for the route. Supported only for WebSocket APIs.
     */
    public val modelSelectionExpression: kotlin.String? = builder.modelSelectionExpression
    /**
     * The operation name for the route.
     */
    public val operationName: kotlin.String? = builder.operationName
    /**
     * The request models for the route. Supported only for WebSocket APIs.
     */
    public val requestModels: Map<String, String>? = builder.requestModels
    /**
     * The request parameters for the route. Supported only for WebSocket APIs.
     */
    public val requestParameters: Map<String, ParameterConstraints>? = builder.requestParameters
    /**
     * The route key for the route.
     */
    public val routeKey: kotlin.String? = builder.routeKey
    /**
     * The route response selection expression for the route. Supported only for WebSocket APIs.
     */
    public val routeResponseSelectionExpression: kotlin.String? = builder.routeResponseSelectionExpression
    /**
     * The target for the route.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteRequest(")
        append("apiId=$apiId,")
        append("apiKeyRequired=$apiKeyRequired,")
        append("authorizationScopes=$authorizationScopes,")
        append("authorizationType=$authorizationType,")
        append("authorizerId=$authorizerId,")
        append("modelSelectionExpression=$modelSelectionExpression,")
        append("operationName=$operationName,")
        append("requestModels=$requestModels,")
        append("requestParameters=$requestParameters,")
        append("routeKey=$routeKey,")
        append("routeResponseSelectionExpression=$routeResponseSelectionExpression,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (apiKeyRequired?.hashCode() ?: 0)
        result = 31 * result + (authorizationScopes?.hashCode() ?: 0)
        result = 31 * result + (authorizationType?.hashCode() ?: 0)
        result = 31 * result + (authorizerId?.hashCode() ?: 0)
        result = 31 * result + (modelSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (operationName?.hashCode() ?: 0)
        result = 31 * result + (requestModels?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (routeKey?.hashCode() ?: 0)
        result = 31 * result + (routeResponseSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteRequest

        if (apiId != other.apiId) return false
        if (apiKeyRequired != other.apiKeyRequired) return false
        if (authorizationScopes != other.authorizationScopes) return false
        if (authorizationType != other.authorizationType) return false
        if (authorizerId != other.authorizerId) return false
        if (modelSelectionExpression != other.modelSelectionExpression) return false
        if (operationName != other.operationName) return false
        if (requestModels != other.requestModels) return false
        if (requestParameters != other.requestParameters) return false
        if (routeKey != other.routeKey) return false
        if (routeResponseSelectionExpression != other.routeResponseSelectionExpression) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API identifier.
         */
        public var apiId: kotlin.String? = null
        /**
         * Specifies whether an API key is required for the route. Supported only for WebSocket APIs.
         */
        public var apiKeyRequired: kotlin.Boolean? = null
        /**
         * The authorization scopes supported by this route.
         */
        public var authorizationScopes: List<String>? = null
        /**
         * The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer.
         */
        public var authorizationType: aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType? = null
        /**
         * The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer.
         */
        public var authorizerId: kotlin.String? = null
        /**
         * The model selection expression for the route. Supported only for WebSocket APIs.
         */
        public var modelSelectionExpression: kotlin.String? = null
        /**
         * The operation name for the route.
         */
        public var operationName: kotlin.String? = null
        /**
         * The request models for the route. Supported only for WebSocket APIs.
         */
        public var requestModels: Map<String, String>? = null
        /**
         * The request parameters for the route. Supported only for WebSocket APIs.
         */
        public var requestParameters: Map<String, ParameterConstraints>? = null
        /**
         * The route key for the route.
         */
        public var routeKey: kotlin.String? = null
        /**
         * The route response selection expression for the route. Supported only for WebSocket APIs.
         */
        public var routeResponseSelectionExpression: kotlin.String? = null
        /**
         * The target for the route.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteRequest) : this() {
            this.apiId = x.apiId
            this.apiKeyRequired = x.apiKeyRequired
            this.authorizationScopes = x.authorizationScopes
            this.authorizationType = x.authorizationType
            this.authorizerId = x.authorizerId
            this.modelSelectionExpression = x.modelSelectionExpression
            this.operationName = x.operationName
            this.requestModels = x.requestModels
            this.requestParameters = x.requestParameters
            this.routeKey = x.routeKey
            this.routeResponseSelectionExpression = x.routeResponseSelectionExpression
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteRequest = CreateRouteRequest(this)
    }
}
