// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.transform

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType
import aws.sdk.kotlin.services.apigatewayv2.model.ParameterConstraints
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateRouteOperationDeserializer: HttpDeserialize<UpdateRouteResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateRouteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateRouteError(context, call)
        }
        val builder = UpdateRouteResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRouteOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRouteError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRouteOperationBody(builder: UpdateRouteResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIGATEWAYMANAGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiGatewayManaged"))
    val APIKEYREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiKeyRequired"))
    val AUTHORIZATIONSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("authorizationScopes"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authorizationType"))
    val AUTHORIZERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerId"))
    val MODELSELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelSelectionExpression"))
    val OPERATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("operationName"))
    val REQUESTMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestModels"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val ROUTEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeId"))
    val ROUTEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeKey"))
    val ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeResponseSelectionExpression"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIGATEWAYMANAGED_DESCRIPTOR)
        field(APIKEYREQUIRED_DESCRIPTOR)
        field(AUTHORIZATIONSCOPES_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(AUTHORIZERID_DESCRIPTOR)
        field(MODELSELECTIONEXPRESSION_DESCRIPTOR)
        field(OPERATIONNAME_DESCRIPTOR)
        field(REQUESTMODELS_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(ROUTEID_DESCRIPTOR)
        field(ROUTEKEY_DESCRIPTOR)
        field(ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIGATEWAYMANAGED_DESCRIPTOR.index -> builder.apiGatewayManaged = deserializeBoolean()
                APIKEYREQUIRED_DESCRIPTOR.index -> builder.apiKeyRequired = deserializeBoolean()
                AUTHORIZATIONSCOPES_DESCRIPTOR.index -> builder.authorizationScopes =
                    deserializer.deserializeList(AUTHORIZATIONSCOPES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHORIZATIONTYPE_DESCRIPTOR.index -> builder.authorizationType = deserializeString().let { AuthorizationType.fromValue(it) }
                AUTHORIZERID_DESCRIPTOR.index -> builder.authorizerId = deserializeString()
                MODELSELECTIONEXPRESSION_DESCRIPTOR.index -> builder.modelSelectionExpression = deserializeString()
                OPERATIONNAME_DESCRIPTOR.index -> builder.operationName = deserializeString()
                REQUESTMODELS_DESCRIPTOR.index -> builder.requestModels =
                    deserializer.deserializeMap(REQUESTMODELS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                REQUESTPARAMETERS_DESCRIPTOR.index -> builder.requestParameters =
                    deserializer.deserializeMap(REQUESTPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ParameterConstraints>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeParameterConstraintsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ROUTEID_DESCRIPTOR.index -> builder.routeId = deserializeString()
                ROUTEKEY_DESCRIPTOR.index -> builder.routeKey = deserializeString()
                ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.routeResponseSelectionExpression = deserializeString()
                TARGET_DESCRIPTOR.index -> builder.target = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
