// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.CreateApiMappingRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApiMappingOperationSerializer: HttpSerialize<CreateApiMappingRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateApiMappingRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainName) { "domainName is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "v2",
                "domainnames",
                "${input.domainName}".encodeLabel(),
                "apimappings",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateApiMappingOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApiMappingOperationBody(context: ExecutionContext, input: CreateApiMappingRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiId"))
    val APIMAPPINGKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiMappingKey"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIID_DESCRIPTOR)
        field(APIMAPPINGKEY_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiId?.let { field(APIID_DESCRIPTOR, it) }
        input.apiMappingKey?.let { field(APIMAPPINGKEY_DESCRIPTOR, it) }
        input.stage?.let { field(STAGE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
