// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponseResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreateIntegrationResponseOperationDeserializer: HttpDeserialize<CreateIntegrationResponseResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateIntegrationResponseResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIntegrationResponseError(context, call)
        }
        val builder = CreateIntegrationResponseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateIntegrationResponseOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateIntegrationResponseError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIntegrationResponseOperationBody(builder: CreateIntegrationResponseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandlingStrategy"))
    val INTEGRATIONRESPONSEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseId"))
    val INTEGRATIONRESPONSEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseKey"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(INTEGRATIONRESPONSEID_DESCRIPTOR)
        field(INTEGRATIONRESPONSEKEY_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENTHANDLINGSTRATEGY_DESCRIPTOR.index -> builder.contentHandlingStrategy = deserializeString().let { ContentHandlingStrategy.fromValue(it) }
                INTEGRATIONRESPONSEID_DESCRIPTOR.index -> builder.integrationResponseId = deserializeString()
                INTEGRATIONRESPONSEKEY_DESCRIPTOR.index -> builder.integrationResponseKey = deserializeString()
                RESPONSEPARAMETERS_DESCRIPTOR.index -> builder.responseParameters =
                    deserializer.deserializeMap(RESPONSEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESPONSETEMPLATES_DESCRIPTOR.index -> builder.responseTemplates =
                    deserializer.deserializeMap(RESPONSETEMPLATES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.templateSelectionExpression = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
