// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings
import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class UpdateStageOperationDeserializer: HttpDeserialize<UpdateStageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateStageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateStageError(context, call)
        }
        val builder = UpdateStageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateStageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateStageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateStageOperationBody(builder: UpdateStageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSLOGSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessLogSettings"))
    val APIGATEWAYMANAGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiGatewayManaged"))
    val AUTODEPLOY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoDeploy"))
    val CLIENTCERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientCertificateId"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DEFAULTROUTESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultRouteSettings"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LASTDEPLOYMENTSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lastDeploymentStatusMessage"))
    val LASTUPDATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedDate"))
    val ROUTESETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("routeSettings"))
    val STAGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stageName"))
    val STAGEVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("stageVariables"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSLOGSETTINGS_DESCRIPTOR)
        field(APIGATEWAYMANAGED_DESCRIPTOR)
        field(AUTODEPLOY_DESCRIPTOR)
        field(CLIENTCERTIFICATEID_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DEFAULTROUTESETTINGS_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LASTDEPLOYMENTSTATUSMESSAGE_DESCRIPTOR)
        field(LASTUPDATEDDATE_DESCRIPTOR)
        field(ROUTESETTINGS_DESCRIPTOR)
        field(STAGENAME_DESCRIPTOR)
        field(STAGEVARIABLES_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSLOGSETTINGS_DESCRIPTOR.index -> builder.accessLogSettings = deserializeAccessLogSettingsDocument(deserializer)
                APIGATEWAYMANAGED_DESCRIPTOR.index -> builder.apiGatewayManaged = deserializeBoolean()
                AUTODEPLOY_DESCRIPTOR.index -> builder.autoDeploy = deserializeBoolean()
                CLIENTCERTIFICATEID_DESCRIPTOR.index -> builder.clientCertificateId = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromIso8601(it) }
                DEFAULTROUTESETTINGS_DESCRIPTOR.index -> builder.defaultRouteSettings = deserializeRouteSettingsDocument(deserializer)
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LASTDEPLOYMENTSTATUSMESSAGE_DESCRIPTOR.index -> builder.lastDeploymentStatusMessage = deserializeString()
                LASTUPDATEDDATE_DESCRIPTOR.index -> builder.lastUpdatedDate = deserializeString().let { Instant.fromIso8601(it) }
                ROUTESETTINGS_DESCRIPTOR.index -> builder.routeSettings =
                    deserializer.deserializeMap(ROUTESETTINGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, RouteSettings>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeRouteSettingsDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STAGENAME_DESCRIPTOR.index -> builder.stageName = deserializeString()
                STAGEVARIABLES_DESCRIPTOR.index -> builder.stageVariables =
                    deserializer.deserializeMap(STAGEVARIABLES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
