// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.AuthorizationType
import aws.sdk.kotlin.services.apigatewayv2.model.ParameterConstraints
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateRouteRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRouteOperationSerializer: HttpSerialize<UpdateRouteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateRouteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            requireNotNull(input.routeId) { "routeId is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "routes",
                "${input.routeId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateRouteOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateRouteOperationBody(context: ExecutionContext, input: UpdateRouteRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIKEYREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiKeyRequired"))
    val AUTHORIZATIONSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("authorizationScopes"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authorizationType"))
    val AUTHORIZERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerId"))
    val MODELSELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelSelectionExpression"))
    val OPERATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("operationName"))
    val REQUESTMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestModels"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val ROUTEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeKey"))
    val ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeResponseSelectionExpression"))
    val TARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("target"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYREQUIRED_DESCRIPTOR)
        field(AUTHORIZATIONSCOPES_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(AUTHORIZERID_DESCRIPTOR)
        field(MODELSELECTIONEXPRESSION_DESCRIPTOR)
        field(OPERATIONNAME_DESCRIPTOR)
        field(REQUESTMODELS_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(ROUTEKEY_DESCRIPTOR)
        field(ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR)
        field(TARGET_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiKeyRequired?.let { field(APIKEYREQUIRED_DESCRIPTOR, it) }
        if (input.authorizationScopes != null) {
            listField(AUTHORIZATIONSCOPES_DESCRIPTOR) {
                for (el0 in input.authorizationScopes) {
                    serializeString(el0)
                }
            }
        }
        input.authorizationType?.let { field(AUTHORIZATIONTYPE_DESCRIPTOR, it.value) }
        input.authorizerId?.let { field(AUTHORIZERID_DESCRIPTOR, it) }
        input.modelSelectionExpression?.let { field(MODELSELECTIONEXPRESSION_DESCRIPTOR, it) }
        input.operationName?.let { field(OPERATIONNAME_DESCRIPTOR, it) }
        if (input.requestModels != null) {
            mapField(REQUESTMODELS_DESCRIPTOR) {
                input.requestModels.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.requestParameters != null) {
            mapField(REQUESTPARAMETERS_DESCRIPTOR) {
                input.requestParameters.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeParameterConstraintsDocument)) }
            }
        }
        input.routeKey?.let { field(ROUTEKEY_DESCRIPTOR, it) }
        input.routeResponseSelectionExpression?.let { field(ROUTERESPONSESELECTIONEXPRESSION_DESCRIPTOR, it) }
        input.target?.let { field(TARGET_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
