// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The domain name configuration.
 */
public class DomainNameConfiguration private constructor(builder: Builder) {
    /**
     * A domain name for the API.
     */
    public val apiGatewayDomainName: kotlin.String? = builder.apiGatewayDomainName
    /**
     * An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
     */
    public val certificateUploadDate: aws.smithy.kotlin.runtime.time.Instant? = builder.certificateUploadDate
    /**
     * The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.
     */
    public val domainNameStatus: aws.sdk.kotlin.services.apigatewayv2.model.DomainNameStatus? = builder.domainNameStatus
    /**
     * An optional text message containing detailed information about status of the domain name migration.
     */
    public val domainNameStatusMessage: kotlin.String? = builder.domainNameStatusMessage
    /**
     * The endpoint type.
     */
    public val endpointType: aws.sdk.kotlin.services.apigatewayv2.model.EndpointType? = builder.endpointType
    /**
     * The Amazon Route 53 Hosted Zone ID of the endpoint.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn
     */
    public val ownershipVerificationCertificateArn: kotlin.String? = builder.ownershipVerificationCertificateArn
    /**
     * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.
     */
    public val securityPolicy: aws.sdk.kotlin.services.apigatewayv2.model.SecurityPolicy? = builder.securityPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.DomainNameConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainNameConfiguration(")
        append("apiGatewayDomainName=$apiGatewayDomainName,")
        append("certificateArn=$certificateArn,")
        append("certificateName=$certificateName,")
        append("certificateUploadDate=$certificateUploadDate,")
        append("domainNameStatus=$domainNameStatus,")
        append("domainNameStatusMessage=$domainNameStatusMessage,")
        append("endpointType=$endpointType,")
        append("hostedZoneId=$hostedZoneId,")
        append("ownershipVerificationCertificateArn=$ownershipVerificationCertificateArn,")
        append("securityPolicy=$securityPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiGatewayDomainName?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (certificateUploadDate?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatus?.hashCode() ?: 0)
        result = 31 * result + (domainNameStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (ownershipVerificationCertificateArn?.hashCode() ?: 0)
        result = 31 * result + (securityPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainNameConfiguration

        if (apiGatewayDomainName != other.apiGatewayDomainName) return false
        if (certificateArn != other.certificateArn) return false
        if (certificateName != other.certificateName) return false
        if (certificateUploadDate != other.certificateUploadDate) return false
        if (domainNameStatus != other.domainNameStatus) return false
        if (domainNameStatusMessage != other.domainNameStatusMessage) return false
        if (endpointType != other.endpointType) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (ownershipVerificationCertificateArn != other.ownershipVerificationCertificateArn) return false
        if (securityPolicy != other.securityPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.DomainNameConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A domain name for the API.
         */
        public var apiGatewayDomainName: kotlin.String? = null
        /**
         * An AWS-managed certificate that will be used by the edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The user-friendly name of the certificate that will be used by the edge-optimized endpoint for this domain name.
         */
        public var certificateName: kotlin.String? = null
        /**
         * The timestamp when the certificate that was used by edge-optimized endpoint for this domain name was uploaded.
         */
        public var certificateUploadDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the domain name migration. The valid values are AVAILABLE, UPDATING, PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the status is UPDATING, the domain cannot be modified further until the existing operation is complete. If it is AVAILABLE, the domain can be updated.
         */
        public var domainNameStatus: aws.sdk.kotlin.services.apigatewayv2.model.DomainNameStatus? = null
        /**
         * An optional text message containing detailed information about status of the domain name migration.
         */
        public var domainNameStatusMessage: kotlin.String? = null
        /**
         * The endpoint type.
         */
        public var endpointType: aws.sdk.kotlin.services.apigatewayv2.model.EndpointType? = null
        /**
         * The Amazon Route 53 Hosted Zone ID of the endpoint.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * The ARN of the public certificate issued by ACM to validate ownership of your custom domain. Only required when configuring mutual TLS and using an ACM imported or private CA certificate ARN as the regionalCertificateArn
         */
        public var ownershipVerificationCertificateArn: kotlin.String? = null
        /**
         * The Transport Layer Security (TLS) version of the security policy for this domain name. The valid values are TLS_1_0 and TLS_1_2.
         */
        public var securityPolicy: aws.sdk.kotlin.services.apigatewayv2.model.SecurityPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.DomainNameConfiguration) : this() {
            this.apiGatewayDomainName = x.apiGatewayDomainName
            this.certificateArn = x.certificateArn
            this.certificateName = x.certificateName
            this.certificateUploadDate = x.certificateUploadDate
            this.domainNameStatus = x.domainNameStatus
            this.domainNameStatusMessage = x.domainNameStatusMessage
            this.endpointType = x.endpointType
            this.hostedZoneId = x.hostedZoneId
            this.ownershipVerificationCertificateArn = x.ownershipVerificationCertificateArn
            this.securityPolicy = x.securityPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.DomainNameConfiguration = DomainNameConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
