// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.ConnectionType
import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.CreateIntegrationResponse
import aws.sdk.kotlin.services.apigatewayv2.model.IntegrationType
import aws.sdk.kotlin.services.apigatewayv2.model.PassthroughBehavior
import aws.sdk.kotlin.services.apigatewayv2.model.TlsConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class CreateIntegrationOperationDeserializer: HttpDeserialize<CreateIntegrationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIntegrationError(context, call)
        }
        val builder = CreateIntegrationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateIntegrationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIntegrationOperationBody(builder: CreateIntegrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIGATEWAYMANAGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiGatewayManaged"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CONNECTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("connectionType"))
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandlingStrategy"))
    val CREDENTIALSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentialsArn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INTEGRATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationId"))
    val INTEGRATIONMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationMethod"))
    val INTEGRATIONRESPONSESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseSelectionExpression"))
    val INTEGRATIONSUBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationSubtype"))
    val INTEGRATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("integrationType"))
    val INTEGRATIONURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationUri"))
    val PASSTHROUGHBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("passthroughBehavior"))
    val PAYLOADFORMATVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("payloadFormatVersion"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTTEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestTemplates"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSEPARAMETERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val TIMEOUTINMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutInMillis"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIGATEWAYMANAGED_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONTYPE_DESCRIPTOR)
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(CREDENTIALSARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INTEGRATIONID_DESCRIPTOR)
        field(INTEGRATIONMETHOD_DESCRIPTOR)
        field(INTEGRATIONRESPONSESELECTIONEXPRESSION_DESCRIPTOR)
        field(INTEGRATIONSUBTYPE_DESCRIPTOR)
        field(INTEGRATIONTYPE_DESCRIPTOR)
        field(INTEGRATIONURI_DESCRIPTOR)
        field(PASSTHROUGHBEHAVIOR_DESCRIPTOR)
        field(PAYLOADFORMATVERSION_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTTEMPLATES_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
        field(TIMEOUTINMILLIS_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIGATEWAYMANAGED_DESCRIPTOR.index -> builder.apiGatewayManaged = deserializeBoolean()
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CONNECTIONTYPE_DESCRIPTOR.index -> builder.connectionType = deserializeString().let { ConnectionType.fromValue(it) }
                CONTENTHANDLINGSTRATEGY_DESCRIPTOR.index -> builder.contentHandlingStrategy = deserializeString().let { ContentHandlingStrategy.fromValue(it) }
                CREDENTIALSARN_DESCRIPTOR.index -> builder.credentialsArn = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                INTEGRATIONID_DESCRIPTOR.index -> builder.integrationId = deserializeString()
                INTEGRATIONMETHOD_DESCRIPTOR.index -> builder.integrationMethod = deserializeString()
                INTEGRATIONRESPONSESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.integrationResponseSelectionExpression = deserializeString()
                INTEGRATIONSUBTYPE_DESCRIPTOR.index -> builder.integrationSubtype = deserializeString()
                INTEGRATIONTYPE_DESCRIPTOR.index -> builder.integrationType = deserializeString().let { IntegrationType.fromValue(it) }
                INTEGRATIONURI_DESCRIPTOR.index -> builder.integrationUri = deserializeString()
                PASSTHROUGHBEHAVIOR_DESCRIPTOR.index -> builder.passthroughBehavior = deserializeString().let { PassthroughBehavior.fromValue(it) }
                PAYLOADFORMATVERSION_DESCRIPTOR.index -> builder.payloadFormatVersion = deserializeString()
                REQUESTPARAMETERS_DESCRIPTOR.index -> builder.requestParameters =
                    deserializer.deserializeMap(REQUESTPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                REQUESTTEMPLATES_DESCRIPTOR.index -> builder.requestTemplates =
                    deserializer.deserializeMap(REQUESTTEMPLATES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESPONSEPARAMETERS_DESCRIPTOR.index -> builder.responseParameters =
                    deserializer.deserializeMap(RESPONSEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Map<String, String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeMap(RESPONSEPARAMETERS_C0_DESCRIPTOR) {
                                        val map1 = mutableMapOf<String, String>()
                                        while (hasNextEntry()) {
                                            val k1 = key()
                                            val v1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            map1[k1] = v1
                                        }
                                        map1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.templateSelectionExpression = deserializeString()
                TIMEOUTINMILLIS_DESCRIPTOR.index -> builder.timeoutInMillis = deserializeInt()
                TLSCONFIG_DESCRIPTOR.index -> builder.tlsConfig = deserializeTlsConfigDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
