// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.AuthorizerType
import aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerResponse
import aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateAuthorizerOperationDeserializer: HttpDeserialize<CreateAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAuthorizerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAuthorizerError(context, call)
        }
        val builder = CreateAuthorizerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAuthorizerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAuthorizerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAuthorizerOperationBody(builder: CreateAuthorizerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHORIZERCREDENTIALSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerCredentialsArn"))
    val AUTHORIZERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerId"))
    val AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerPayloadFormatVersion"))
    val AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("authorizerResultTtlInSeconds"))
    val AUTHORIZERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authorizerType"))
    val AUTHORIZERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerUri"))
    val ENABLESIMPLERESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableSimpleResponses"))
    val IDENTITYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("identitySource"))
    val IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityValidationExpression"))
    val JWTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jwtConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZERCREDENTIALSARN_DESCRIPTOR)
        field(AUTHORIZERID_DESCRIPTOR)
        field(AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR)
        field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR)
        field(AUTHORIZERTYPE_DESCRIPTOR)
        field(AUTHORIZERURI_DESCRIPTOR)
        field(ENABLESIMPLERESPONSES_DESCRIPTOR)
        field(IDENTITYSOURCE_DESCRIPTOR)
        field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR)
        field(JWTCONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHORIZERCREDENTIALSARN_DESCRIPTOR.index -> builder.authorizerCredentialsArn = deserializeString()
                AUTHORIZERID_DESCRIPTOR.index -> builder.authorizerId = deserializeString()
                AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR.index -> builder.authorizerPayloadFormatVersion = deserializeString()
                AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR.index -> builder.authorizerResultTtlInSeconds = deserializeInt()
                AUTHORIZERTYPE_DESCRIPTOR.index -> builder.authorizerType = deserializeString().let { AuthorizerType.fromValue(it) }
                AUTHORIZERURI_DESCRIPTOR.index -> builder.authorizerUri = deserializeString()
                ENABLESIMPLERESPONSES_DESCRIPTOR.index -> builder.enableSimpleResponses = deserializeBoolean()
                IDENTITYSOURCE_DESCRIPTOR.index -> builder.identitySource =
                    deserializer.deserializeList(IDENTITYSOURCE_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR.index -> builder.identityValidationExpression = deserializeString()
                JWTCONFIGURATION_DESCRIPTOR.index -> builder.jwtConfiguration = deserializeJwtConfigurationDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
