// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Updates an Api.
 */
public class UpdateApiRequest private constructor(builder: Builder) {
    /**
     * The API identifier.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     */
    public val apiKeySelectionExpression: kotlin.String? = builder.apiKeySelectionExpression
    /**
     * A CORS configuration. Supported only for HTTP APIs.
     */
    public val corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = builder.corsConfiguration
    /**
     * This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.
     */
    public val credentialsArn: kotlin.String? = builder.credentialsArn
    /**
     * The description of the API.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    public val disableExecuteApiEndpoint: kotlin.Boolean? = builder.disableExecuteApiEndpoint
    /**
     * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     */
    public val disableSchemaValidation: kotlin.Boolean? = builder.disableSchemaValidation
    /**
     * The name of the API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.
     */
    public val routeKey: kotlin.String? = builder.routeKey
    /**
     * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     */
    public val routeSelectionExpression: kotlin.String? = builder.routeSelectionExpression
    /**
     * This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.
     */
    public val target: kotlin.String? = builder.target
    /**
     * A version identifier for the API.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApiRequest(")
        append("apiId=$apiId,")
        append("apiKeySelectionExpression=$apiKeySelectionExpression,")
        append("corsConfiguration=$corsConfiguration,")
        append("credentialsArn=$credentialsArn,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("disableSchemaValidation=$disableSchemaValidation,")
        append("name=$name,")
        append("routeKey=$routeKey,")
        append("routeSelectionExpression=$routeSelectionExpression,")
        append("target=$target,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (apiKeySelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (corsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (credentialsArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint?.hashCode() ?: 0)
        result = 31 * result + (disableSchemaValidation?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (routeKey?.hashCode() ?: 0)
        result = 31 * result + (routeSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApiRequest

        if (apiId != other.apiId) return false
        if (apiKeySelectionExpression != other.apiKeySelectionExpression) return false
        if (corsConfiguration != other.corsConfiguration) return false
        if (credentialsArn != other.credentialsArn) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (disableSchemaValidation != other.disableSchemaValidation) return false
        if (name != other.name) return false
        if (routeKey != other.routeKey) return false
        if (routeSelectionExpression != other.routeSelectionExpression) return false
        if (target != other.target) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API identifier.
         */
        public var apiId: kotlin.String? = null
        /**
         * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
         */
        public var apiKeySelectionExpression: kotlin.String? = null
        /**
         * A CORS configuration. Supported only for HTTP APIs.
         */
        public var corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = null
        /**
         * This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs.
         */
        public var credentialsArn: kotlin.String? = null
        /**
         * The description of the API.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        public var disableExecuteApiEndpoint: kotlin.Boolean? = null
        /**
         * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         */
        public var disableSchemaValidation: kotlin.Boolean? = null
        /**
         * The name of the API.
         */
        public var name: kotlin.String? = null
        /**
         * This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs.
         */
        public var routeKey: kotlin.String? = null
        /**
         * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
         */
        public var routeSelectionExpression: kotlin.String? = null
        /**
         * This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs.
         */
        public var target: kotlin.String? = null
        /**
         * A version identifier for the API.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest) : this() {
            this.apiId = x.apiId
            this.apiKeySelectionExpression = x.apiKeySelectionExpression
            this.corsConfiguration = x.corsConfiguration
            this.credentialsArn = x.credentialsArn
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.disableSchemaValidation = x.disableSchemaValidation
            this.name = x.name
            this.routeKey = x.routeKey
            this.routeSelectionExpression = x.routeSelectionExpression
            this.target = x.target
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiRequest = UpdateApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.Cors] inside the given [block]
         */
        public fun corsConfiguration(block: aws.sdk.kotlin.services.apigatewayv2.model.Cors.Builder.() -> kotlin.Unit) {
            this.corsConfiguration = aws.sdk.kotlin.services.apigatewayv2.model.Cors.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
