// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateIntegrationResponseRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateIntegrationResponseOperationSerializer: HttpSerializer.NonStreaming<UpdateIntegrationResponseRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateIntegrationResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            requireNotNull(input.integrationId) { "integrationId is bound to the URI and must not be null" }
            requireNotNull(input.integrationResponseId) { "integrationResponseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode("${input.apiId}"))
                add(PercentEncoding.Path.encode("integrations"))
                add(PercentEncoding.SmithyLabel.encode("${input.integrationId}"))
                add(PercentEncoding.Path.encode("integrationresponses"))
                add(PercentEncoding.SmithyLabel.encode("${input.integrationResponseId}"))
            }
        }

        val payload = serializeUpdateIntegrationResponseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateIntegrationResponseOperationBody(context: ExecutionContext, input: UpdateIntegrationResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTHANDLINGSTRATEGY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandlingStrategy"))
    val INTEGRATIONRESPONSEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationResponseKey"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val RESPONSETEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseTemplates"))
    val TEMPLATESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateSelectionExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR)
        field(INTEGRATIONRESPONSEKEY_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(RESPONSETEMPLATES_DESCRIPTOR)
        field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.contentHandlingStrategy?.let { field(CONTENTHANDLINGSTRATEGY_DESCRIPTOR, it.value) }
        input.integrationResponseKey?.let { field(INTEGRATIONRESPONSEKEY_DESCRIPTOR, it) }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        if (input.responseTemplates != null) {
            mapField(RESPONSETEMPLATES_DESCRIPTOR) {
                input.responseTemplates.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.templateSelectionExpression?.let { field(TEMPLATESELECTIONEXPRESSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
