// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ExportApiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ExportApiOperationSerializer: HttpSerializer.NonStreaming<ExportApiRequest> {
    override fun serialize(context: ExecutionContext, input: ExportApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.apiId) { "apiId is bound to the URI and must not be null" }
            requireNotNull(input.specification) { "specification is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("apis"))
                add(PercentEncoding.SmithyLabel.encode(input.apiId))
                add(PercentEncoding.Path.encode("exports"))
                add(PercentEncoding.SmithyLabel.encode(input.specification))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.exportVersion != null) add("exportVersion", input.exportVersion)
                if (input.includeExtensions != null) add("includeExtensions", input.includeExtensions.toString())
                if (input.outputType != null) add("outputType", input.outputType)
                if (input.stageName != null) add("stageName", input.stageName)
            }
        }

        return builder
    }
}
