// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateStageResponse private constructor(builder: Builder) {
    /**
     * Settings for logging access in this stage.
     */
    public val accessLogSettings: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings? = builder.accessLogSettings
    /**
     * Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.
     */
    public val apiGatewayManaged: kotlin.Boolean? = builder.apiGatewayManaged
    /**
     * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
     */
    public val autoDeploy: kotlin.Boolean? = builder.autoDeploy
    /**
     * The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
     */
    public val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * The timestamp when the stage was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * Default route settings for the stage.
     */
    public val defaultRouteSettings: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings? = builder.defaultRouteSettings
    /**
     * The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The description of the stage.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.
     */
    public val lastDeploymentStatusMessage: kotlin.String? = builder.lastDeploymentStatusMessage
    /**
     * The timestamp when the stage was last updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * Route settings for the stage, by routeKey.
     */
    public val routeSettings: Map<String, RouteSettings>? = builder.routeSettings
    /**
     * The name of the stage.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
     */
    public val stageVariables: Map<String, String>? = builder.stageVariables
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStageResponse(")
        append("accessLogSettings=$accessLogSettings,")
        append("apiGatewayManaged=$apiGatewayManaged,")
        append("autoDeploy=$autoDeploy,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("defaultRouteSettings=$defaultRouteSettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("lastDeploymentStatusMessage=$lastDeploymentStatusMessage,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("routeSettings=$routeSettings,")
        append("stageName=$stageName,")
        append("stageVariables=$stageVariables,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (apiGatewayManaged?.hashCode() ?: 0)
        result = 31 * result + (autoDeploy?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteSettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (routeSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStageResponse

        if (accessLogSettings != other.accessLogSettings) return false
        if (apiGatewayManaged != other.apiGatewayManaged) return false
        if (autoDeploy != other.autoDeploy) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (defaultRouteSettings != other.defaultRouteSettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (lastDeploymentStatusMessage != other.lastDeploymentStatusMessage) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (routeSettings != other.routeSettings) return false
        if (stageName != other.stageName) return false
        if (stageVariables != other.stageVariables) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Settings for logging access in this stage.
         */
        public var accessLogSettings: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings? = null
        /**
         * Specifies whether a stage is managed by API Gateway. If you created an API using quick create, the $default stage is managed by API Gateway. You can't modify the $default stage.
         */
        public var apiGatewayManaged: kotlin.Boolean? = null
        /**
         * Specifies whether updates to an API automatically trigger a new deployment. The default value is false.
         */
        public var autoDeploy: kotlin.Boolean? = null
        /**
         * The identifier of a client certificate for a Stage. Supported only for WebSocket APIs.
         */
        public var clientCertificateId: kotlin.String? = null
        /**
         * The timestamp when the stage was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Default route settings for the stage.
         */
        public var defaultRouteSettings: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings? = null
        /**
         * The identifier of the Deployment that the Stage is associated with. Can't be updated if autoDeploy is enabled.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The description of the stage.
         */
        public var description: kotlin.String? = null
        /**
         * Describes the status of the last deployment of a stage. Supported only for stages with autoDeploy enabled.
         */
        public var lastDeploymentStatusMessage: kotlin.String? = null
        /**
         * The timestamp when the stage was last updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Route settings for the stage, by routeKey.
         */
        public var routeSettings: Map<String, RouteSettings>? = null
        /**
         * The name of the stage.
         */
        public var stageName: kotlin.String? = null
        /**
         * A map that defines the stage variables for a stage resource. Variable names can have alphanumeric and underscore characters, and the values must match &#91;A-Za-z0-9-._~:/?#&=,&#93;+.
         */
        public var stageVariables: Map<String, String>? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.apiGatewayManaged = x.apiGatewayManaged
            this.autoDeploy = x.autoDeploy
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.defaultRouteSettings = x.defaultRouteSettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.lastDeploymentStatusMessage = x.lastDeploymentStatusMessage
            this.lastUpdatedDate = x.lastUpdatedDate
            this.routeSettings = x.routeSettings
            this.stageName = x.stageName
            this.stageVariables = x.stageVariables
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.UpdateStageResponse = UpdateStageResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings] inside the given [block]
         */
        public fun accessLogSettings(block: aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.apigatewayv2.model.AccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings] inside the given [block]
         */
        public fun defaultRouteSettings(block: aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings.Builder.() -> kotlin.Unit) {
            this.defaultRouteSettings = aws.sdk.kotlin.services.apigatewayv2.model.RouteSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
