// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.DeploymentStatus
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentError(context, call, payload)
        }
        val builder = UpdateDeploymentResponse.Builder()

        if (payload != null) {
            deserializeUpdateDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentOperationBody(builder: UpdateDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTODEPLOYED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("autoDeployed"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val DEPLOYMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("deploymentStatus"))
    val DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentStatusMessage"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTODEPLOYED_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DEPLOYMENTSTATUS_DESCRIPTOR)
        field(DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTODEPLOYED_DESCRIPTOR.index -> builder.autoDeployed = deserializeBoolean()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.ISO_8601)
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                DEPLOYMENTSTATUS_DESCRIPTOR.index -> builder.deploymentStatus = deserializeString().let { DeploymentStatus.fromValue(it) }
                DEPLOYMENTSTATUSMESSAGE_DESCRIPTOR.index -> builder.deploymentStatusMessage = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
