// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.Cors
import aws.sdk.kotlin.services.apigatewayv2.model.ProtocolType
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateApiOperationDeserializer: HttpDeserializer.NonStreaming<UpdateApiResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateApiResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApiError(context, call, payload)
        }
        val builder = UpdateApiResponse.Builder()

        if (payload != null) {
            deserializeUpdateApiOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateApiError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApiOperationBody(builder: UpdateApiResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiEndpoint"))
    val APIGATEWAYMANAGED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiGatewayManaged"))
    val APIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiId"))
    val APIKEYSELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiKeySelectionExpression"))
    val CORSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("corsConfiguration"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdDate"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableExecuteApiEndpoint"))
    val DISABLESCHEMAVALIDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableSchemaValidation"))
    val IMPORTINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("importInfo"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROTOCOLTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("protocolType"))
    val ROUTESELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeSelectionExpression"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val WARNINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("warnings"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIENDPOINT_DESCRIPTOR)
        field(APIGATEWAYMANAGED_DESCRIPTOR)
        field(APIID_DESCRIPTOR)
        field(APIKEYSELECTIONEXPRESSION_DESCRIPTOR)
        field(CORSCONFIGURATION_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR)
        field(DISABLESCHEMAVALIDATION_DESCRIPTOR)
        field(IMPORTINFO_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROTOCOLTYPE_DESCRIPTOR)
        field(ROUTESELECTIONEXPRESSION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(WARNINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIENDPOINT_DESCRIPTOR.index -> builder.apiEndpoint = deserializeString()
                APIGATEWAYMANAGED_DESCRIPTOR.index -> builder.apiGatewayManaged = deserializeBoolean()
                APIID_DESCRIPTOR.index -> builder.apiId = deserializeString()
                APIKEYSELECTIONEXPRESSION_DESCRIPTOR.index -> builder.apiKeySelectionExpression = deserializeString()
                CORSCONFIGURATION_DESCRIPTOR.index -> builder.corsConfiguration = deserializeCorsDocument(deserializer)
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeInstant(TimestampFormat.ISO_8601)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR.index -> builder.disableExecuteApiEndpoint = deserializeBoolean()
                DISABLESCHEMAVALIDATION_DESCRIPTOR.index -> builder.disableSchemaValidation = deserializeBoolean()
                IMPORTINFO_DESCRIPTOR.index -> builder.importInfo =
                    deserializer.deserializeList(IMPORTINFO_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROTOCOLTYPE_DESCRIPTOR.index -> builder.protocolType = deserializeString().let { ProtocolType.fromValue(it) }
                ROUTESELECTIONEXPRESSION_DESCRIPTOR.index -> builder.routeSelectionExpression = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                WARNINGS_DESCRIPTOR.index -> builder.warnings =
                    deserializer.deserializeList(WARNINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
